% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputation.R
\name{imputate_outlier}
\alias{imputate_outlier}
\title{Impute Outliers}
\usage{
imputate_outlier(.data, xvar, method, no_attrs)
}
\arguments{
\item{.data}{a data.frame or a \code{\link{tbl_df}}.}

\item{xvar}{variable name to replace missing value.}

\item{method}{method of missing values imputation.}

\item{no_attrs}{logical. If TRUE, return numerical variable or categorical variable. 
else If FALSE, imputation class.}
}
\value{
An object of imputation class. or numerical variable. 
if no_attrs is FALSE then return imputation class, else no_attrs is TRUE then return
numerical vector.
Attributes of imputation class is as follows.
\itemize{
\item method : method of missing value imputation.
\itemize{
  \item predictor is numerical variable
  \itemize{
    \item "mean" : arithmetic mean
    \item "median" : median
    \item "mode" : mode
    \item "capping" : Impute the upper outliers with 95 percentile,
    and Impute the bottom outliers with 5 percentile.
  }
}
\item outlier_pos : position of outliers in predictor.
\item outliers : outliers. outliers corresponding to outlier_pos.
\item type : "outliers". type of imputation.
}
}
\description{
Outliers are imputed with some representative values and statistical methods.
}
\details{
imputate_outlier() creates an imputation class.
The `imputation` class includes missing value position, imputed value,
and method of missing value imputation, etc.
The `imputation` class compares the imputed value with the original value
to help determine whether the imputed value is used in the analysis.

See vignette("transformation") for an introduction to these concepts.
}
\examples{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# Replace the outliers of the Price variable with median
imputate_outlier(carseats, Price, method = "median")

# Replace the outliers of the Price variable with capping
imputate_outlier(carseats, Price, method = "capping")

## using dplyr -------------------------------------
library(dplyr)

# The mean before and after the imputation of the Price variable
carseats \%>\%
  mutate(Price_imp = imputate_outlier(carseats, Price, method = "capping", no_attrs = TRUE)) \%>\%
  group_by(US) \%>\%
  summarise(orig = mean(Price, na.rm = TRUE),
    imputation = mean(Price_imp, na.rm = TRUE))

# If the variable of interest is a numerical variable
price <- imputate_outlier(carseats, Price)
price
summary(price)
plot(price)
}
\seealso{
\code{\link{imputate_na}}.
}
