% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_percentile}
\alias{get_percentile}
\title{Finding percentile}
\usage{
get_percentile(x, value, from = 0, to = 1, eps = 1e-06)
}
\arguments{
\item{x}{numeric. a numeric vector.}

\item{value}{numeric. a scalar to find percentile value from vector x.}

\item{from}{numeric. Start interval in logic to find percentile value. default to 0.}

\item{to}{numeric. End interval in logic to find percentile value. default to 1.}

\item{eps}{numeric. Threshold value for calculating the approximate value in recursive 
calling logic to find the percentile value. (epsilon). default to 1e-06.}
}
\value{
list.
Components of list. is as follows.
\itemize{
\item percentile : numeric. Percentile position of value. It has a value between [0, 100].
\item is_outlier : logical. Whether value is an outlier.
}
}
\description{
Find the percentile of the value specified in numeric vector.
}
\examples{
carat <- ggplot2::diamonds$carat

quantile(carat)

get_percentile(carat, value = 0.5)
get_percentile(carat, value = median(carat))
get_percentile(carat, value = 1)
get_percentile(carat, value = 7)
}
