% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter-dm.R
\name{dm_get_filters}
\alias{dm_get_filters}
\title{Get filter expressions}
\usage{
dm_get_filters(dm)
}
\arguments{
\item{dm}{A \code{dm} object.}
}
\value{
A tibble with the following columns:
\describe{
\item{\code{table}}{table that was filtered,}
\item{\code{filter}}{the filter expression,}
\item{\code{zoomed}}{logical, does the filter condition relate to the zoomed table.}
}
}
\description{
\code{dm_get_filters()} returns the filter expressions that have been applied to a \code{dm} object.
These filter expressions are not intended for evaluation, only for
information.
}
\section{Life cycle}{

This function is marked "questioning" because it feels wrong
to tightly couple filtering with the data model.
On the one hand, an overview of active filters is useful
when specifying the base data set for an analysis in terms of column selections
and row filters.
However, these filter condition should be only of informative nature
and never affect the results of other operations.
We are working on formalizing the semantics of the underlying operations
in order to present them in a cleaner interface.

Use \code{\link[=dm_zoom_to]{dm_zoom_to()}} and \code{\link[dplyr:filter]{dplyr::filter()}} to filter rows without registering
the filter.
}

\examples{
\dontshow{if (rlang::is_installed("nycflights13") && rlang::is_installed("dbplyr")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
dm_nycflights13() \%>\%
  dm_get_filters()
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=dm_filter]{dm_filter()}}, \code{\link[=dm_apply_filters]{dm_apply_filters()}}
}
