% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schema.R
\name{db_schema_exists}
\alias{db_schema_exists}
\title{Check for existence of a schema on a database}
\usage{
db_schema_exists(con, schema, ...)
}
\arguments{
\item{con}{An object of class \code{"src"} or \code{"DBIConnection"}.}

\item{schema}{Class \code{character} or \code{SQL}, name of the schema}

\item{...}{Passed on to the individual methods.}
}
\value{
A boolean: \code{TRUE} if schema exists, \code{FALSE} otherwise.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{db_schema_exists()} checks, if a schema exists on the database.
}
\details{
Methods are not available for all DBMS.

Additional arguments are:
\itemize{
\item \code{dbname}: supported for MSSQL. Check if a schema exists on a different
database on the connected MSSQL-server; default: database addressed by \code{con}.
}
}
\seealso{
Other schema handling functions: 
\code{\link{db_schema_create}()},
\code{\link{db_schema_drop}()},
\code{\link{db_schema_list}()}
}
\concept{schema handling functions}
