% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinates2sequence.R
\name{coordinates2sequence}
\alias{coordinates2sequence}
\title{Generates a DNA Sequence Based on an X and Y Coordinate over several iterations}
\arguments{
\item{xstart}{the starting x coordinate in the fractal image}

\item{ystart}{the starting y coordinate in the fractal image}

\item{n}{the number of bases to be calculated in the DNA sequence}
}
\value{
The DNA sequence
}
\description{
The function takes an X and Y coordinate and a number of bases to be represented in the DNA sequence.
The function starts at the provided X and Y coordinates and then works backward, calculating every preceding base
in the DNA sequence that led to that particular point in the fractal. Based on the actual X, Y point's coordinate,
the base pair corresponding to that coordinate is inferred, and the DNA string will be built up and returned as the
product of the function.

Version 0.0.1.
Author: Dr. Matthew Cserhati
Email: matthew.cserhati@cui.edu
May 5, 2025
}
\examples{
coordinates2sequence(-10,90,25)
}
\references{
Jeffrey, H. J. (1990) Chaos game representation of gene structure. Nucleic Acids Research 18(8):2163-70.

Hill, K. A., Schisler, N. J., and Singh, S. M. (1992) Chaos game representation of coding regions of human globin genes and alcohol dehydrogenase genes of phylogenetically divergent species. Journal of Molecular Evolution 35:261-269.

Löchel, H. F., and Heider, D. (2021) Chaos game representation and its applications in bioinformatics. Computational and Structural Biotechnology Journal 19(2021): 6263-6271.
}
