% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summarize_genes}
\alias{summarize_genes}
\title{Summarize the differential connectivity of genes over all pathways.}
\usage{
summarize_genes(x, alpha = 0.1, monotonized = FALSE)
}
\arguments{
\item{x}{A 'dnapath_list' object from \code{\link{dnapath}}.}

\item{alpha}{Threshold for p-values of gene DC scores. Used to determine
the number of pathways that each gene is differentially connected in.
Defaults to 0.1 or the minimum possible threshold for the number
of permutations performed, whichever is greater.}

\item{monotonized}{If TRUE, monotonized p-values are used.}
}
\value{
A tibble summarizing the differential connectivity of genes across
all pathways.
}
\description{
Summarize the differential connectivity of genes over all pathways.
}
\examples{
data(meso)
data(p53_pathways)
set.seed(0)
results <- dnapath(x = meso$gene_expression, pathway_list = p53_pathways,
                   group_labels = meso$groups, n_perm = 10)
summarize_genes(results) # Summary of genes across all pathways.
summarize_genes(results[[1]]) # Summary of genes within the first pathway.
}
\seealso{
\code{\link{summarize_pathways}}, \code{\link{summarize_edges}}
}
