% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restrict_env.R
\name{restrict}
\alias{restrict}
\alias{restrict_sub}
\alias{restrict_env}
\alias{restrictions}
\alias{original_fun}
\title{restrict}
\usage{
restrict(fun, args, method = "env")

restrict_sub(fun, args, envir = parent.frame())

restrict_env(fun, args)

restrictions(object)

original_fun(object)
}
\arguments{
\item{fun}{Function to be restricted}

\item{args}{List of the form name=value}

\item{method}{Either "env" (default, using an auxillary argument
for storing restricted values) or "sub" (based on substituting
fixed values into the function).}

\item{envir}{Environment}

\item{object}{An object from restrict (a scaffold object).}
}
\description{
Restrict a functions domain by fixing certain
  arguments of a function call.
}
\details{
`restrict` is a wrapper for calling `restrict_env` (default) or `restrict_sub`.
}
\examples{

f1  <- function(x, y){x + y}
f1_ <- restrict(f1, list(y=10))
f1_
f1_(x=1)
restrictions(f1_)
original_fun(f1_)

f2 <- function(x){
  x <- x + 2
  x
}
f2_ <- restrict(f2, list(x=1)) 
f2_()

# Notice that this is absurd:
restrict(f2, list(x=10), method="sub")

rnorm10 <- restrict(rnorm, list(n=10)) 
rnorm(10)
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk} based on code
  adapted from the curry package.
}
