% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dock_from_desc.R
\name{dock_from_desc}
\alias{dock_from_desc}
\title{Create a Dockerfile from a DESCRIPTION}
\usage{
dock_from_desc(
  path = "DESCRIPTION",
  FROM = paste0("rocker/r-ver:", R.Version()$major, ".", R.Version()$minor),
  AS = NULL,
  sysreqs = TRUE,
  repos = c(CRAN = "https://cran.rstudio.com/"),
  expand = FALSE,
  update_tar_gz = TRUE,
  build_from_source = TRUE,
  extra_sysreqs = NULL
)
}
\arguments{
\item{path}{path to the DESCRIPTION file to use as an input.}

\item{FROM}{The FROM of the Dockerfile. Default is
FROM rocker/r-ver:`R.Version()$major`.`R.Version()$minor`.}

\item{AS}{The AS of the Dockerfile. Default it NULL.}

\item{sysreqs}{boolean. If TRUE, the Dockerfile will contain sysreq installation.}

\item{repos}{character. The URL(s) of the repositories to use for `options("repos")`.}

\item{expand}{boolean. If `TRUE` each system requirement will have its own `RUN` line.}

\item{update_tar_gz}{boolean. If `TRUE` and `build_from_source` is also `TRUE`,
an updated tar.gz is created.}

\item{build_from_source}{boolean. If `TRUE` no tar.gz is created and
the Dockerfile directly mount the source folder.}

\item{extra_sysreqs}{character vector. Extra debian system requirements.
Will be installed with apt-get install.}
}
\description{
Create a Dockerfile from a DESCRIPTION
}
