% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dock_from_renv.R
\name{dock_from_renv}
\alias{dock_from_renv}
\title{Create a Dockerfile from an `renv.lock` file}
\usage{
dock_from_renv(
  lockfile = "renv.lock",
  distro = "focal",
  FROM = "rocker/r-base",
  AS = NULL,
  sysreqs = TRUE,
  repos = c(CRAN = "https://cran.rstudio.com/"),
  expand = FALSE,
  extra_sysreqs = NULL
)
}
\arguments{
\item{lockfile}{Path to an `renv.lock` file to use as an input..}

\item{distro}{One of "focal", "bionic", "xenial", "centos7",
or "centos8". See available distributions
at https://hub.docker.com/r/rstudio/r-base/.}

\item{FROM}{Docker image to start FROM Default is
FROM rocker/r-base}

\item{AS}{The AS of the Dockerfile. Default it NULL.}

\item{sysreqs}{boolean. If `TRUE`, the Dockerfile
will contain sysreq installation.}

\item{repos}{character. The URL(s) of the repositories to use for `options("repos")`.}

\item{expand}{boolean. If `TRUE` each system requirement will have its own `RUN` line.}

\item{extra_sysreqs}{character vector. Extra debian system requirements.
Will be installed with apt-get install.}
}
\value{
A R6 object of class `Dockerfile`.
}
\description{
Create a Dockerfile from an `renv.lock` file
}
\details{
System requirements for packages are provided
through RStudio Package Manager via the {pak}
package. The install commands provided from pak
are added as `RUN` directives within the `Dockerfile`.

The R version is taken from the `renv.lock` file.
Packages are installed using `renv::restore()` which ensures
that the proper package version and source is used when installed.
}
\examples{
\dontrun{
dock <- dock_from_renv("renv.lock", distro = "xenial")
dock$write("Dockerfile")
}
}
