% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dock_from_renv.R
\name{dock_from_renv}
\alias{dock_from_renv}
\title{Create a Dockerfile from an \code{renv.lock} file}
\usage{
dock_from_renv(
  lockfile = "renv.lock",
  distro = NULL,
  FROM = "rocker/r-base",
  AS = NULL,
  sysreqs = TRUE,
  repos = c(CRAN = "https://cran.rstudio.com/"),
  expand = FALSE,
  extra_sysreqs = NULL,
  use_pak = FALSE,
  user = NULL,
  dependencies = NA,
  sysreqs_platform = "ubuntu",
  renv_version
)
}
\arguments{
\item{lockfile}{Path to an \code{renv.lock} file to use as an input..}

\item{distro}{\itemize{
\item deprecated - only debian/ubuntu based images are supported
}}

\item{FROM}{Docker image to start FROM Default is FROM rocker/r-base}

\item{AS}{The AS of the Dockerfile. Default it \code{NULL}.}

\item{sysreqs}{boolean. If \code{TRUE}, the Dockerfile will contain sysreq installation.}

\item{repos}{character. The URL(s) of the repositories to use for \code{options("repos")}.}

\item{expand}{boolean. If \code{TRUE} each system requirement will have its own \code{RUN} line.}

\item{extra_sysreqs}{character vector. Extra debian system requirements.
Will be installed with apt-get install.}

\item{use_pak}{boolean. If \code{TRUE} use pak to deal with dependencies  during \code{renv::restore()}. FALSE by default}

\item{user}{Name of the user to specify in the Dockerfile with the USER instruction. Default is \code{NULL}, in which case the user from the FROM image is used.}

\item{dependencies}{What kinds of dependencies to install. Most commonly
one of the following values:
\itemize{
\item \code{NA}: only required (hard) dependencies,
\item \code{TRUE}: required dependencies plus optional and development
dependencies,
\item \code{FALSE}: do not install any dependencies. (You might end up with a
non-working package, and/or the installation might fail.)
}}

\item{sysreqs_platform}{System requirements platform.\code{ubuntu} by default. If \code{NULL}, then the  current platform is used. Can be : "ubuntu-22.04" if needed to fit with the \code{FROM} Operating System. Only debian or ubuntu based images are supported}

\item{renv_version}{character. The renv version to use in the generated Dockerfile. By default, it is set to the version specified in the \code{renv.lock} file.
If the \code{renv.lock} file does not specify a renv version,
the version of renv bundled with dockerfiler,
specifically 1.0.3, will be used.
If you set it to \code{NULL}, the latest available version of renv will be used.}
}
\value{
A R6 object of class \code{Dockerfile}.
}
\description{
Create a Dockerfile from an \code{renv.lock} file
}
\details{
System requirements for packages are provided
through RStudio Package Manager via the pak
package. The install commands provided from pak
are added as \code{RUN} directives within the \code{Dockerfile}.

The R version is taken from the \code{renv.lock} file.
Packages are installed using \code{renv::restore()} which ensures
that the proper package version and source is used when installed.
}
\examples{
\dontrun{
dock <- dock_from_renv("renv.lock", distro = "xenial")
dock$write("Dockerfile")
}
}
