% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{fisherI}
\alias{fisherI}
\title{Fisher Information}
\usage{
fisherI(ff, theta, parNames, yspace, ...)
}
\arguments{
\item{ff}{either \itemize{
\item \code{function(y, theta, i, j, ...)} which evaluates to the inner part of the expectation integral/sum.
\item \code{list(f=function(y, theta, ...), d2logf=function(y, theta, i, j, ...))} (recommended)
\item \code{list(f=function(y, theta, ...), dlogf=function(y, theta, i, ...))}
}
where \code{f} is the joint probability density function and \code{dlogf}/\code{d2logf} is the first/second derivative of \code{log(f)} with respect to \code{theta[[i]]}/\code{theta[[i]]} and \code{theta[[j]]}.}

\item{theta}{the list of parameters.}

\item{parNames}{a vector of names or indices, the subset of parameters to use.}

\item{yspace}{a space, the support of \code{y}.}

\item{...}{other arguments passed to \code{ff}.}
}
\value{
\code{fisherI} returns a named matrix, the Fisher information.
}
\description{
\code{fisherI} utilizes \code{nint_integrate} to evaluate the Fisher information.
}
\details{
If \code{ff} is a list, it shall contain \code{dlogf} xor \code{d2logf}.
}
\examples{
## see examples for param

}
\seealso{
\code{\link{buildf}}, \code{\link{numDerivLogf}}, \code{\link{DerivLogf}}, \code{\link{nint_space}}, \code{\link{nint_transform}}, \code{\link{nint_integrate}}, \code{\link{param}}
}

