% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{Wynn}
\alias{Wynn}
\title{Wynn}
\usage{
Wynn(sensF, tol, maxIter = 10000)
}
\arguments{
\item{sensF}{\code{function(x=NULL, desw=NULL, desx=NULL, mod=NULL)}, a sensitivity function.
It's attribute \code{"defaults"} shall contain identical \code{x} and \code{desx}, and \code{sensF(desw=w)} shall return sensitivities corresponding to each point in \code{x}.}

\item{tol}{the tolerance level regarding the sensitivities.}

\item{maxIter}{the maximum number of iterations.}
}
\value{
\code{Wynn} returns an object of \code{class} \code{"desigh"}.
See \code{\link{design}} for its structural definition.
}
\description{
\code{Wynn} finds an optimal design using a sensitivity function and a Wynn-algorithm.
}
\details{
See \code{\link{Dsensitivity}} and it's return value for a reference implementation of a function complying with the requirements for \code{sensF}.

The algorithm starts from a uniform weight design.
In each iteration weight is redistributed to the point which has the highest sensitivity.
Sequence: \code{1/i}.
The algorithm stops when all sensitivities are below a specified tolerance level or the maximum number of iterations is reached.
}
\examples{
## see examples for param

}
\references{
Wynn, Henry P. (1970) The Sequential Generation of D-Optimum Experimental Designs.
\emph{The Annals of Mathematical Statistics}, 41(5):1655-1664.
}
\seealso{
\code{\link{Dsensitivity}}, \code{\link{design}}
}
