% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dists.R
\name{dodgr_distances}
\alias{dodgr_distances}
\title{dodgr_distances}
\usage{
dodgr_distances(graph, from, to, wt_profile = "bicycle", expand = 0,
  heap = "BHeap", parallel = TRUE, quiet = TRUE)
}
\arguments{
\item{graph}{\code{data.frame} or equivalent object representing the network
graph (see Details)}

\item{from}{Vector or matrix of points **from** which route distances are to
be calculated (see Details)}

\item{to}{Vector or matrix of points **to** which route distances are to be
calculated (see Details)}

\item{wt_profile}{Name of weighting profile for street networks (one of foot,
horse, wheelchair, bicycle, moped, motorcycle, motorcar, goods, hgv, psv).}

\item{expand}{Only when \code{graph} not given, the multiplicative factor by
which to expand the street network surrounding the points defined by
\code{from} and/or \code{to}.}

\item{heap}{Type of heap to use in priority queue. Options include
Fibonacci Heap (default; \code{FHeap}), Binary Heap (\code{BHeap}),
\code{Radix}, Trinomial Heap (\code{TriHeap}), Extended Trinomial Heap
(\code{TriHeapExt}, and 2-3 Heap (\code{Heap23}).}

\item{parallel}{If \code{TRUE}, perform routing calculation in parallel (see
details)}

\item{quiet}{If \code{FALSE}, display progress messages on screen.}
}
\value{
square matrix of distances between nodes
}
\description{
Alias for \link{dodgr_dists}
}
\examples{
# A simple graph
graph <- data.frame (from = c ("A", "B", "B", "B", "C", "C", "D", "D"),
                     to = c ("B", "A", "C", "D", "B", "D", "C", "A"),
                     d = c (1, 2, 1, 3, 2, 1, 2, 1))
dodgr_dists (graph)

# A larger example from the included \\code{\\link{hampi}} data.
graph <- weight_streetnet (hampi)
from <- sample (graph$from_id, size = 100)
to <- sample (graph$to_id, size = 50)
d <- dodgr_dists (graph, from = from, to = to)
# d is a 100-by-50 matrix of distances between \\code{from} and \\code{to}

\dontrun{
# a more complex street network example, thanks to @chrijo; see
# https://github.com/ATFutures/dodgr/issues/47

xy <- rbind (c (7.005994, 51.45774), # limbeckerplatz 1 essen germany
             c (7.012874, 51.45041)) # hauptbahnhof essen germany
xy <- data.frame (lon = xy [, 1], lat = xy [, 2])
essen <- dodgr_streetnet (pts = xy, expand = 0.2, quiet = FALSE)
graph <- weight_streetnet (essen, wt_profile = "foot")
d <- dodgr_dists (graph, from = xy, to = xy)
# First reason why this does not work is because the graph has multiple,
# disconnected components.
table (graph$component)
# reduce to largest connected component, which is always number 1
graph <- graph [which (graph$component == 1), ]
d <- dodgr_dists (graph, from = xy, to = xy)
# should work, but even then note that
table (essen$level)
# There are parts of the network on different building levels (because of
# shopping malls and the like). These may or may not be connected, so it may be
# necessary to filter out particular levels
levs <- paste0 (essen$level) # because sf data are factors
index <- which (! (levs == "-1" | levs == "1")) # for example
library (sf) # needed for following sub-select operation
essen <- essen [index, ]
graph <- weight_streetnet (essen, wt_profile = "foot")
d <- dodgr_dists (graph, from = xy, to = xy)
}
}
