% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph-contraction.R
\name{dodgr_uncontract_graph}
\alias{dodgr_uncontract_graph}
\title{dodgr_uncontract_graph}
\usage{
dodgr_uncontract_graph(graph)
}
\arguments{
\item{graph}{A list of two items returned from \link{dodgr_contract_graph},
the first ("graph") containing the contracted graph, and the second
("edge_map") mapping edges in the contracted graph back to those in the
original graph.}
}
\value{
A single \code{data.frame} representing the original, uncontracted graph.
}
\description{
Revert a contracted graph created with \link{dodgr_contract_graph} back to
the full, uncontracted version. This function is mostly used for the side
effect of mapping any new columnns inserted on to the contracted graph back
on to the original graph, as demonstrated in the example.
}
\examples{
graph0 <- weight_streetnet (hampi)
nrow (graph0) # 5,845
graph1 <- dodgr_contract_graph (graph0)
nrow (graph1) # 686
graph2 <- dodgr_uncontract_graph (graph1)
nrow (graph2) # 5,845

# Insert new data on to the contracted graph and uncontract it:
graph1$new_col <- runif (nrow (graph1))
graph3 <- dodgr_uncontract_graph (graph1)
# graph3 is then the uncontracted graph which includes "new_col" as well
dim (graph0); dim (graph3)
}
