% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph-functions.R
\name{dodgr_sample}
\alias{dodgr_sample}
\title{dodgr_sample}
\usage{
dodgr_sample(graph, nverts = 1000)
}
\arguments{
\item{graph}{A flat table of graph edges. Must contain columns labelled
\code{from} and \code{to}, or \code{start} and \code{stop}. May also contain
similarly labelled columns of spatial coordinates (for example
\code{from_x}) or \code{stop_lon}).}

\item{nverts}{Number of vertices to sample}
}
\value{
A connected sub-component of \code{graph}
}
\description{
Sample a random but connected sub-component of a graph
}
\note{
Graphs may occasionally have \code{nverts + 1} vertices, rather than
the requested \code{nverts}.
}
\examples{
graph <- weight_streetnet (hampi)
nrow (graph) # 5,742
graph <- dodgr_sample (graph, nverts = 200)
nrow (graph) # generally around 400 edges
nrow (dodgr_vertices (graph)) # 200
}
