% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centrality.R
\name{estimate_centrality_time}
\alias{estimate_centrality_time}
\title{estimate_centrality_time}
\usage{
estimate_centrality_time(
  graph,
  contract = TRUE,
  edges = TRUE,
  dist_threshold = NULL,
  heap = "BHeap"
)
}
\arguments{
\item{graph}{'data.frame' or equivalent object representing the network
graph (see Details)}

\item{contract}{If 'TRUE', centrality is calculated on contracted graph
before mapping back on to the original full graph. Note that for street
networks, in particular those obtained from the \pkg{osmdata} package, vertex
placement is effectively arbitrary except at junctions; centrality for such
graphs should only be calculated between the latter points, and thus
'contract' should always be 'TRUE'.}

\item{edges}{If 'TRUE', centrality is calculated for graph edges, returning
the input 'graph' with an additional 'centrality' column; otherwise
centrality is calculated for vertices, returning the equivalent of
'dodgr_vertices(graph)', with an additional vertex-based 'centrality' column.}

\item{dist_threshold}{If not 'NULL', only calculate centrality for each point
out to specified threshold. Setting values for this will result in
approximate estimates for centrality, yet with considerable gains in
computational efficiency. For sufficiently large values, approximations will
be accurate to within some constant multiplier. Appropriate values can be
established via the \link{estimate_centrality_threshold} function.}

\item{heap}{Type of heap to use in priority queue. Options include
Fibonacci Heap (default; 'FHeap'), Binary Heap ('BHeap'),
Trinomial Heap ('TriHeap'), Extended Trinomial Heap
('TriHeapExt', and 2-3 Heap ('Heap23').}
}
\value{
An estimated calculation time for calculating centrality for the
given value of 'dist_threshold'
}
\description{
The 'dodgr' centrality functions are designed to be applied to potentially
very large graphs, and may take considerable time to execute. This helper
function estimates how long a centrality function may take for a given graph
and given value of 'dist_threshold' estimated via the
\link{estimate_centrality_threshold} function.
}
\note{
This function may take some time to execute. While running, it displays
ongoing information on screen of estimated values of 'dist_threshold' and
associated errors. Thresholds are progressively increased until the error is
reduced below the specified tolerance.
}
