% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/door_ci.R
\name{door_ci}
\alias{door_ci}
\title{Calculate confidence intervals for DOOR probability}
\usage{
door_ci(
  y1 = NULL,
  y2 = NULL,
  n1 = NULL,
  n2 = NULL,
  summary_obj = NULL,
  conf_level = 0.95,
  data_type = c("freq", "prop"),
  ci_method = c("all", "halperin", "ps_h", "tanh"),
  ...
)
}
\arguments{
\item{y1, y2}{Numeric vectors of DOOR proportion or frequency distribution for group 1, group 2.
The entries should be ordered from most desirable to least desirable}

\item{n1, n2}{Sample sizes of group 1, group 2; must be specified if method = "prop"}

\item{summary_obj}{A object returned by \code{individual_to_summary()}; Alternative
input for y1 and y2}

\item{conf_level}{Confidence level}

\item{data_type}{Either "freq" for frequency input or "prop" for proportion input
when using y1 and y2}

\item{ci_method}{One of "all" for all available methods, "halperin" for Halperin et al. (1989)'s
method, "ps_h" for pseudo-score approach for Halperin's method, "tanh" for inverse
hyperbolc tangent transformed method}

\item{...}{Additional parameters passed for calculating pseudo-score type confidence interval}
}
\value{
List of CIs
}
\description{
This is a wrapper function for all CI calculation functions
}
\examples{
door_ci(c(60,30,10), c(50,40,10), ci_method = "all")
}
\seealso{
\code{\link[=halperin_ci]{halperin_ci()}}, \code{\link[=pseudo_score_ci]{pseudo_score_ci()}}
}
