% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset.R
\docType{data}
\name{ci_ex}
\alias{ci_ex}
\title{Cumulative incidence data on high-fat dairy food and colorectal cancer risk}
\format{A data frame with 5 observations on the following 8 variables:
\tabular{ll}{
\code{dose} \tab assigned dose levels.\cr
\code{case} \tab number of cases for each exposure level.\cr
\code{n} \tab total number of subjects for each exposure level.\cr
\code{adjrr} \tab adjusted risk ratios for each exposure level.\cr
\code{lb} \tab lower bound for the confidence limits of the adjusted risk ratios.\cr
\code{ub} \tab upper bound for the confidence limits of the adjusted risk ratios.\cr
\code{logrr} \tab natural logarithm of adjusted risk ratios.\cr
\code{se} \tab standard error for the logarithm of the adjusted risk ratios.\cr
}}
\description{
The dataset reports the summarized dose-response results from a cumlative-incidence study
on high-fat dairy food intake and risk of colorectal cancer, first presented by Larsson, Bergkvist, and Wolk (2005).
}
\references{
Larsson, S. C., L. Bergkvist, and A. Wolk. (2005). High-fat dairy food and conjugated 
linoleic acid intakes in relation to colorectal cancer incidence in the Swedish Mammography 
Cohort. American Journal of Clinical Nutrition 82: 894-900.

Greenland, S.,  Longnecker, M. P. (1992). Methods for trend estimation from summarized dose-response data, with applications to meta-analysis.
American journal of epidemiology, 135(11), 1301-1309.
}
\author{
Alessio Crippa, <\email{alessio.crippa@ki.se}>
}
\keyword{data}
