% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dots.R
\name{dots_points}
\alias{dots_points}
\title{Make dot density points}
\usage{
dots_points(
  shp,
  cols,
  engine = engine_terra,
  divisor = 250,
  min_point = 0.1 * divisor
)
}
\arguments{
\item{shp}{input shp with \code{sf} geometry.}

\item{cols}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> columns to produce dots for.}

\item{engine}{backend to use. Default is \code{engine_terra}.}

\item{divisor}{Number of people per dot. Default is 250.}

\item{min_point}{Minimum number of people to generate one dot. Defaults to 10\% of the divisor.}
}
\value{
tibble with \code{sf} geometries
}
\description{
Make dot density points
}
\examples{
data('suffolk')
# subset to first 20 rows for speed on CRAN
dots_points(suffolk[1:20, ], c(vap_black))
}
