% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dwplot.R
\name{dwplot}
\alias{dwplot}
\title{Dot-and-Whisker Plots of Regression Coefficients from Tidy Data Frames}
\usage{
dwplot(df, alpha = 0.05, dodge_size = 0.15)
}
\arguments{
\item{df}{A data.frame including the variables \code{term} (names of independent variables), \code{estimate} (corresponding coefficient estimates), \code{std.error} (corresponding standard errors), and optionally \code{model} (when multiple models are desired on a single plot) such as generated those by \code{\link[broom]{tidy}}.}

\item{alpha}{A number setting the criterion of the confidence intervals. The default value is .05, corresponding to 95-percent confidence intervals.}

\item{dodge_size}{A number (typically between 0 and 0.3) indicating how much vertical separation should be between different models' coefficients when multiple models are graphed in a single plot.  Lower values tend to look better when the number of independent variables is small.}
}
\value{
The function returns a \code{ggplot} object.
}
\description{
\code{dwplot} is a function for quickly and easily generating dot-and-whisker plots of regression models saved in tidy data frames.
}
\details{
\code{dwplot} visualizes regression results saved in tidy data.frames by, e.g., \code{\link[broom]{tidy}} as dot-and-whisker plots generated by \code{\link[ggplot2]{ggplot}}.

Because the function takes a data.frame as input, it is easily employed for a wide range of models, and because the output is a \code{ggplot} object, it can be further customized with any additional arguments and layers supported by \code{ggplot2}.
}
\examples{
library(broom)

# Plot regression coefficients from a single model
data(mtcars)
m1 <- lm(mpg ~ wt + cyl + disp, data = mtcars)
m1_df <- tidy(m1) # create data.frame of regression results

dwplot(m1_df) +
    scale_y_discrete(breaks = 4:1, labels=c("Intercept", "Weight", "Cylinders", "Displacement")) +
    theme_bw() + xlab("Coefficient") + ylab("") +
    geom_vline(xintercept = 0, colour = "grey50", linetype = 2) +
    theme(legend.position="none")

# Plot regression coefficients from multiple models
library(dplyr)
by_trans <- mtcars \%>\% group_by(am) \%>\%
    do(tidy(lm(mpg ~ wt + cyl + disp, data = .))) \%>\% rename(model=am)

dwplot(by_trans, dodge_size = .05) +
    scale_y_discrete(breaks = 4:1, labels=c("Intercept", "Weight", "Cylinders", "Displacement")) +
    theme_bw() + xlab("Coefficient Estimate") + ylab("") +
    geom_vline(xintercept = 0, colour = "grey60", linetype = 2) +
    ggtitle("Predicting Gas Mileage, OLS Estimates") +
    theme(plot.title = element_text(face="bold"),
          legend.justification=c(1,0), legend.position=c(1,0),
          legend.background = element_rect(colour="grey80"),
          legend.title.align = .5) +
    scale_colour_grey(start = .4, end = .8,
                      name = "Transmission",
                      breaks = c(0, 1),
                      labels = c("Automatic", "Manual"))
}
\references{
Kastellec, Jonathan P. and Leoni, Eduardo L. 2007. "Using Graphs Instead of Tables in Political Science." Perspectives on Politics, 5(4):755-771.
}

