% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colwise-select.R
\name{select_all}
\alias{select_all}
\alias{rename_all}
\alias{select_if}
\alias{rename_if}
\alias{select_at}
\alias{rename_at}
\title{Select and rename a selection of variables}
\usage{
select_all(.tbl, .funs = list(), ...)

rename_all(.tbl, .funs = list(), ...)

select_if(.tbl, .predicate, .funs = list(), ...)

rename_if(.tbl, .predicate, .funs = list(), ...)

select_at(.tbl, .vars, .funs = list(), ...)

rename_at(.tbl, .vars, .funs = list(), ...)
}
\arguments{
\item{.tbl}{A \code{tbl} object.}

\item{.funs}{A single expression quoted with \code{\link[=funs]{funs()}} or within a
quosure, a string naming a function, or a function.}

\item{...}{Additional arguments for the function calls in
\code{.funs}. These are evaluated only once, with \link[rlang:dots_list]{explicit
splicing}.}

\item{.predicate}{A predicate function to be applied to the columns
or a logical vector. The variables for which \code{.predicate} is or
returns \code{TRUE} are selected. This argument is passed to
\code{\link[rlang:as_function]{rlang::as_function()}} and thus supports quosure-style lambda
functions and strings representing function names.}

\item{.vars}{A list of columns generated by \code{\link[=vars]{vars()}},
or a character vector of column names, or a numeric vector of column
positions.}
}
\description{
These \link{scoped} variants of \code{\link[=select]{select()}} and \code{\link[=rename]{rename()}} operate on a
selection of variables. The semantics of these verbs have simple
but important differences:
\itemize{
\item Selection drops variables that are not in the selection while
renaming retains them.
\item The renaming function is optional for selection but not for
renaming.
}
}
\examples{
# Supply a renaming function:
select_all(mtcars, toupper)
select_all(mtcars, "toupper")
select_all(mtcars, funs(toupper(.)))

# Selection drops unselected variables:
is_whole <- function(x) all(floor(x) == x)
select_if(mtcars, is_whole, toupper)

# But renaming retains them:
rename_if(mtcars, is_whole, toupper)

# The renaming function is optional for selection:
select_if(mtcars, is_whole)
}
