% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sets.r
\name{setops}
\alias{setops}
\alias{intersect}
\alias{union}
\alias{union_all}
\alias{setdiff}
\alias{setequal}
\title{Set operations}
\usage{
intersect(x, y, ...)

union(x, y, ...)

union_all(x, y, ...)

setdiff(x, y, ...)

setequal(x, y, ...)
}
\arguments{
\item{x, y}{objects to perform set function on (ignoring order)}

\item{...}{other arguments passed on to methods}
}
\description{
These functions override the set functions provided in base to make them
generic so that efficient versions for data frames and other tables can be
provided. The default methods call the base versions.
}
\examples{
mtcars$model <- rownames(mtcars)
first <- mtcars[1:20, ]
second <- mtcars[10:32, ]

intersect(first, second)
union(first, second)
setdiff(first, second)
setdiff(second, first)

union_all(first, second)
setequal(mtcars, mtcars[32:1, ])
}
