% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colwise.R
\name{scoped}
\alias{scoped}
\title{Operate on a selection of variables}
\arguments{
\item{.tbl}{A \code{tbl} object.}

\item{.funs}{List of function calls generated by \code{\link[=funs]{funs()}}, or a
character vector of function names, or simply a function.

Bare formulas are passed to \code{\link[rlang:as_function]{rlang::as_function()}} to create
purrr-style lambda functions. Note that these lambda prevent
hybrid evaluation from happening and it is thus more efficient to
supply functions like \code{mean()} directly rather than in a
lambda-formula.}

\item{.vars}{A list of columns generated by \code{\link[=vars]{vars()}},
a character vector of column names, a numeric vector of column
positions, or \code{NULL}.}

\item{.predicate}{A predicate function to be applied to the columns
or a logical vector. The variables for which \code{.predicate} is or
returns \code{TRUE} are selected. This argument is passed to
\code{\link[rlang:as_function]{rlang::as_function()}} and thus supports quosure-style lambda
functions and strings representing function names.}

\item{...}{Additional arguments for the function calls in
\code{.funs}. These are evaluated only once, with \link[rlang:tidy-dots]{tidy
dots} support.}
}
\description{
The variants suffixed with \code{_if}, \code{_at} or \code{_all} apply an
expression (sometimes several) to all variables within a specified
subset. This subset can contain all variables (\code{_all} variants), a
\code{\link[=vars]{vars()}} selection (\code{_at} variants), or variables selected with a
predicate (\code{_if} variants).
}
\details{
The verbs with scoped variants are:
\itemize{
\item \code{\link[=mutate]{mutate()}}, \code{\link[=transmute]{transmute()}} and \code{\link[=summarise]{summarise()}}. See \code{\link[=summarise_all]{summarise_all()}}.
\item \code{\link[=filter]{filter()}}. See \code{\link[=filter_all]{filter_all()}}.
\item \code{\link[=group_by]{group_by()}}. See \code{\link[=group_by_all]{group_by_all()}}.
\item \code{\link[=rename]{rename()}} and \code{\link[=select]{select()}}. See \code{\link[=select_all]{select_all()}}.
\item \code{\link[=arrange]{arrange()}}. See \code{\link[=arrange_all]{arrange_all()}}
}

There are three kinds of scoped variants. They differ in the scope
of the variable selection on which operations are applied:
\itemize{
\item Verbs suffixed with \code{_all()} apply an operation on all variables.
\item Verbs suffixed with \code{_at()} apply an operation on a subset of
variables specified with the quoting function \code{\link[=vars]{vars()}}. This
quoting function accepts \code{\link[tidyselect:vars_select]{tidyselect::vars_select()}} helpers like
\code{\link[=starts_with]{starts_with()}}. Instead of a \code{\link[=vars]{vars()}} selection, you can also
supply an \link[rlang:is_integerish]{integerish} vector of column
positions or a character vector of column names.
\item Verbs suffixed with \code{_if()} apply an operation on the subset of
variables for which a predicate function returns \code{TRUE}. Instead
of a predicate function, you can also supply a logical vector.
}
}
