% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count-tally.R
\name{tally}
\alias{tally}
\alias{count}
\alias{add_tally}
\alias{add_count}
\title{Count/tally observations by group}
\usage{
tally(x, wt, sort = FALSE)

count(x, ..., wt = NULL, sort = FALSE)

add_tally(x, wt, sort = FALSE)

add_count(x, ..., wt = NULL, sort = FALSE)
}
\arguments{
\item{x}{a \code{\link[=tbl]{tbl()}} to tally/count.}

\item{wt}{(Optional) If omitted (and no variable named \code{n} exists in the
data), will count the number of rows.
If specified, will perform a "weighted" tally by summing the
(non-missing) values of variable \code{wt}. A column named \code{n} (but not \code{nn} or
\code{nnn}) will be used as weighting variable by default in \code{tally()}, but not
in \code{count()}. This argument is automatically \link[rlang:quo]{quoted} and later
\link[rlang:eval_tidy]{evaluated} in the context of the data
frame. It supports \link[rlang:quasiquotation]{unquoting}. See
\code{vignette("programming")} for an introduction to these concepts.}

\item{sort}{if \code{TRUE} will sort output in descending order of \code{n}}

\item{...}{Variables to group by.}
}
\value{
A tbl, grouped the same way as \code{x}.
}
\description{
\code{tally()} is a convenient wrapper for summarise that will either call
\code{\link[=n]{n()}} or \code{\link{sum}(n)} depending on whether you're tallying
for the first time, or re-tallying. \code{count()} is similar but calls
\code{\link[=group_by]{group_by()}} before and \code{\link[=ungroup]{ungroup()}} after.

\code{add_tally()} adds a column \code{n} to a table based on the number
of items within each existing group, while \code{add_count()} is a shortcut that
does the grouping as well. These functions are to \code{\link[=tally]{tally()}}
and \code{\link[=count]{count()}} as \code{\link[=mutate]{mutate()}} is to \code{\link[=summarise]{summarise()}}:
they add an additional column rather than collapsing each group.
}
\note{
The column name in the returned data is usually \code{n}, even if you
have supplied a weight.

If the data already already has a column named \code{n}, the output column
will be called \code{nn}. If the table already has columns called \code{n} and \code{nn}
then the column returned will be \code{nnn}, and so on.

There is currently no way to control the output variable name - if you
need to change the default, you'll have to write the \code{\link[=summarise]{summarise()}}
yourself.
}
\examples{
# tally() is short-hand for summarise()
mtcars \%>\% tally()
# count() is a short-hand for group_by() + tally()
mtcars \%>\% count(cyl)

# add_tally() is short-hand for mutate()
mtcars \%>\% add_tally()
# add_count() is a short-hand for group_by() + add_tally()
mtcars \%>\% add_count(cyl)

# count and tally are designed so that you can call
# them repeatedly, each time rolling up a level of detail
species <- starwars \%>\% count(species, homeworld, sort = TRUE)
species
species \%>\% count(species, sort = TRUE)

# add_count() is useful for groupwise filtering
# e.g.: show only species that have a single member
starwars \%>\%
  add_count(species) \%>\%
  filter(n == 1)
}
