% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na_if.R
\name{na_if}
\alias{na_if}
\title{Convert values to NA}
\usage{
na_if(x, y)
}
\arguments{
\item{x}{Vector to modify}

\item{y}{Value to replace with NA}
}
\value{
A modified version of \code{x} that replaces any values that
are equal to \code{y} with NA.
}
\description{
This is a translation of the SQL command \code{NULL_IF}. It is useful
if you want to convert an annoying value to \code{NA}.
}
\examples{
na_if(1:5, 5:1)

x <- c(1, -1, 0, 10)
100 / x
100 / na_if(x, 0)

y <- c("abc", "def", "", "ghi")
na_if(y, "")
}
\seealso{
\code{\link[=coalesce]{coalesce()}} to replace missing values with a specified
value.
}
