% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join.R
\name{mutate-joins}
\alias{mutate-joins}
\alias{join}
\alias{join.data.frame}
\alias{inner_join}
\alias{inner_join.data.frame}
\alias{left_join}
\alias{left_join.data.frame}
\alias{right_join}
\alias{right_join.data.frame}
\alias{full_join}
\alias{full_join.data.frame}
\title{Mutating joins}
\usage{
inner_join(
  x,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c(".x", ".y"),
  ...,
  keep = NULL
)

\method{inner_join}{data.frame}(
  x,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c(".x", ".y"),
  ...,
  keep = NULL,
  na_matches = c("na", "never"),
  multiple = NULL,
  unmatched = "drop"
)

left_join(
  x,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c(".x", ".y"),
  ...,
  keep = NULL
)

\method{left_join}{data.frame}(
  x,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c(".x", ".y"),
  ...,
  keep = NULL,
  na_matches = c("na", "never"),
  multiple = NULL,
  unmatched = "drop"
)

right_join(
  x,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c(".x", ".y"),
  ...,
  keep = NULL
)

\method{right_join}{data.frame}(
  x,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c(".x", ".y"),
  ...,
  keep = NULL,
  na_matches = c("na", "never"),
  multiple = NULL,
  unmatched = "drop"
)

full_join(
  x,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c(".x", ".y"),
  ...,
  keep = NULL
)

\method{full_join}{data.frame}(
  x,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c(".x", ".y"),
  ...,
  keep = NULL,
  na_matches = c("na", "never"),
  multiple = NULL
)
}
\arguments{
\item{x, y}{A pair of data frames, data frame extensions (e.g. a tibble), or
lazy data frames (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{by}{A join specification created with \code{\link[=join_by]{join_by()}}, or a character
vector of variables to join by.

If \code{NULL}, the default, \verb{*_join()} will perform a natural join, using all
variables in common across \code{x} and \code{y}. A message lists the variables so
that you can check they're correct; suppress the message by supplying \code{by}
explicitly.

To join on different variables between \code{x} and \code{y}, use a \code{\link[=join_by]{join_by()}}
specification. For example, \code{join_by(a == b)} will match \code{x$a} to \code{y$b}.

To join by multiple variables, use a \code{\link[=join_by]{join_by()}} specification with
multiple expressions. For example, \code{join_by(a == b, c == d)} will match
\code{x$a} to \code{y$b} and \code{x$c} to \code{y$d}. If the column names are the same between
\code{x} and \code{y}, you can shorten this by listing only the variable names, like
\code{join_by(a, c)}.

\code{\link[=join_by]{join_by()}} can also be used to perform inequality, rolling, and overlap
joins. See the documentation at \link[=join_by]{?join_by} for details on
these types of joins.

For simple equality joins, you can alternatively specify a character vector
of variable names to join by. For example, \code{by = c("a", "b")} joins \code{x$a}
to \code{y$a} and \code{x$b} to \code{y$b}. If variable names differ between \code{x} and \code{y},
use a named character vector like \code{by = c("x_a" = "y_a", "x_b" = "y_b")}.

To perform a cross-join, generating all combinations of \code{x} and \code{y}, see
\code{\link[=cross_join]{cross_join()}}.}

\item{copy}{If \code{x} and \code{y} are not from the same data source,
and \code{copy} is \code{TRUE}, then \code{y} will be copied into the
same src as \code{x}.  This allows you to join tables across srcs, but
it is a potentially expensive operation so you must opt into it.}

\item{suffix}{If there are non-joined duplicate variables in \code{x} and
\code{y}, these suffixes will be added to the output to disambiguate them.
Should be a character vector of length 2.}

\item{...}{Other parameters passed onto methods.}

\item{keep}{Should the join keys from both \code{x} and \code{y} be preserved in the
output?
\itemize{
\item If \code{NULL}, the default, joins on equality retain only the keys from \code{x},
while joins on inequality retain the keys from both inputs.
\item If \code{TRUE}, all keys from both inputs are retained.
\item If \code{FALSE}, only keys from \code{x} are retained. For right and full joins,
the data in key columns corresponding to rows that only exist in \code{y} are
merged into the key columns from \code{x}. Can't be used when joining on
inequality conditions.
}}

\item{na_matches}{Should two \code{NA} or two \code{NaN} values match?
\itemize{
\item \code{"na"}, the default, treats two \code{NA} or two \code{NaN} values as equal, like
\code{\%in\%}, \code{\link[=match]{match()}}, and \code{\link[=merge]{merge()}}.
\item \code{"never"} treats two \code{NA} or two \code{NaN} values as different, and will
never match them together or to any other values. This is similar to joins
for database sources and to \code{base::merge(incomparables = NA)}.
}}

\item{multiple}{Handling of rows in \code{x} with multiple matches in \code{y}.
For each row of \code{x}:
\itemize{
\item \code{"all"} returns every match detected in \code{y}. This is the same behavior
as SQL.
\item \code{"any"} returns one match detected in \code{y}, with no guarantees on which
match will be returned. It is often faster than \code{"first"} and \code{"last"}
if you just need to detect if there is at least one match.
\item \code{"first"} returns the first match detected in \code{y}.
\item \code{"last"} returns the last match detected in \code{y}.
\item \code{"warning"} throws a warning if multiple matches are detected, and
then falls back to \code{"all"}.
\item \code{"error"} throws an error if multiple matches are detected.
}

The default value of \code{NULL} is equivalent to \code{"warning"} for equality joins
and rolling joins, where multiple matches are usually surprising. If any
inequality join conditions are present, then it is equivalent to \code{"all"},
since multiple matches are usually expected.}

\item{unmatched}{How should unmatched keys that would result in dropped rows
be handled?
\itemize{
\item \code{"drop"} drops unmatched keys from the result.
\item \code{"error"} throws an error if unmatched keys are detected.
}

\code{unmatched} is intended to protect you from accidentally dropping rows
during a join. It only checks for unmatched keys in the input that could
potentially drop rows.
\itemize{
\item For left joins, it checks \code{y}.
\item For right joins, it checks \code{x}.
\item For inner joins, it checks both \code{x} and \code{y}. In this case, \code{unmatched} is
also allowed to be a character vector of length 2 to specify the behavior
for \code{x} and \code{y} independently.
}}
}
\value{
An object of the same type as \code{x} (including the same groups). The order of
the rows and columns of \code{x} is preserved as much as possible. The output has
the following properties:
\itemize{
\item The rows are affect by the join type.
\itemize{
\item \code{inner_join()} returns matched \code{x} rows.
\item \code{left_join()} returns all \code{x} rows.
\item \code{right_join()}  returns matched of \code{x} rows, followed by unmatched \code{y} rows.
\item \code{full_join()}  returns all \code{x} rows, followed by unmatched \code{y} rows.
}
\item Output columns include all columns from \code{x} and all non-key columns from
\code{y}. If \code{keep = TRUE}, the key columns from \code{y} are included as well.
\item If non-key columns in \code{x} and \code{y} have the same name, \code{suffix}es are added
to disambiguate. If \code{keep = TRUE} and key columns in \code{x} and \code{y} have
the same name, \code{suffix}es are added to disambiguate these as well.
\item If \code{keep = FALSE}, output columns included in \code{by} are coerced to their
common type between \code{x} and \code{y}.
}
}
\description{
Mutating joins add columns from \code{y} to \code{x}, matching observations based on
the keys. There are four mutating joins: the inner join, and the three outer
joins.
\subsection{Inner join}{

An \code{inner_join()} only keeps observations from \code{x} that have a matching key
in \code{y}.

The most important property of an inner join is that unmatched rows in either
input are not included in the result. This means that generally inner joins
are not appropriate in most analyses, because it is too easy to lose
observations.
}

\subsection{Outer joins}{

The three outer joins keep observations that appear in at least one of the
data frames:
\itemize{
\item A \code{left_join()} keeps all observations in \code{x}.
\item A \code{right_join()} keeps all observations in \code{y}.
\item A \code{full_join()} keeps all observations in \code{x} and \code{y}.
}
}

\subsection{Multiple matches}{

By default, if an observation in \code{x} matches multiple observations in \code{y},
all of the matching observations in \code{y} will be returned. If this occurs in
an equality join or a rolling join, a warning will be thrown stating that
multiple matches have been detected since this is usually surprising. If
multiple matches are expected in these cases, silence this warning by
explicitly setting \code{multiple = "all"}.
}
}
\section{Methods}{

These functions are \strong{generic}s, which means that packages can provide
implementations (methods) for other classes. See the documentation of
individual methods for extra arguments and differences in behaviour.

Methods available in currently loaded packages:
\itemize{
\item \code{inner_join()}: \Sexpr[stage=render,results=rd]{dplyr:::methods_rd("inner_join")}.
\item \code{left_join()}: \Sexpr[stage=render,results=rd]{dplyr:::methods_rd("left_join")}.
\item \code{right_join()}: \Sexpr[stage=render,results=rd]{dplyr:::methods_rd("right_join")}.
\item \code{full_join()}: \Sexpr[stage=render,results=rd]{dplyr:::methods_rd("full_join")}.
}
}

\examples{
band_members \%>\% inner_join(band_instruments)
band_members \%>\% left_join(band_instruments)
band_members \%>\% right_join(band_instruments)
band_members \%>\% full_join(band_instruments)

# To suppress the message about joining variables, supply `by`
band_members \%>\% inner_join(band_instruments, by = join_by(name))
# This is good practice in production code

# Use an equality expression if the join variables have different names
band_members \%>\% full_join(band_instruments2, by = join_by(name == artist))
# By default, the join keys from `x` and `y` are coalesced in the output; use
# `keep = TRUE` to keep the join keys from both `x` and `y`
band_members \%>\%
  full_join(band_instruments2, by = join_by(name == artist), keep = TRUE)

# If a row in `x` matches multiple rows in `y`, all the rows in `y` will be
# returned once for each matching row in `x`, with a warning.
df1 <- tibble(x = 1:3)
df2 <- tibble(x = c(1, 1, 2), y = c("first", "second", "third"))
df1 \%>\% left_join(df2)

# If multiple matches are expected, set `multiple` to `"all"` to silence
# the warning
df1 \%>\% left_join(df2, multiple = "all")

# Use `join_by()` with a condition other than `==` to perform an inequality
# join. Here we match on every instance where `df1$x > df2$x`.
df1 \%>\% left_join(df2, join_by(x > x))

# By default, NAs match other NAs so that there are two
# rows in the output of this join:
df1 <- data.frame(x = c(1, NA), y = 2)
df2 <- data.frame(x = c(1, NA), z = 3)
left_join(df1, df2)

# You can optionally request that NAs don't match, giving a
# a result that more closely resembles SQL joins
left_join(df1, df2, na_matches = "never")
}
\seealso{
Other joins: 
\code{\link{cross_join}()},
\code{\link{filter-joins}},
\code{\link{nest_join}()}
}
\concept{joins}
