context("prune")

test_that(
  "prune works on small example and namespaces are used correctly", {
  unlink(cache_path, recursive = TRUE)
  p = example_plan("small")
  expect_equal(cached(), character(0))
  expect_error(prune())
  expect_false(file.exists(cache_path))
  expect_silent(make(p, verbose = F))
  expect_true(file.exists(cache_path))
  expect_true(all(letters[1:6] %in% cached()))
  s = storr::storr_rds(cache_path)
  expect_equal(s$get("f"), 6)
  expect_true(is.list(s$get("f", namespace = "depends")))
  expect_equal(s$list(), letters[1:6])
  expect_equal(s$list(namespace = "depends"), letters[1:6])
  prune(p[1:3,])
  expect_error(s$get("f"))
  expect_error(s$get("f", namespace = "depends"))
  expect_equal(s$list(), letters[1:3])
  expect_equal(s$list(namespace = "depends"), letters[1:3])
  expect_equal(cached(), letters[1:3])
  expect_true(file.exists(cache_path))
  clean(destroy=TRUE)
})

test_that("prune works on debug example", {
  p = example_plan("debug")
  debug_setup()
  expect_equal(cached(), character(0))
  expect_false(file.exists(cache_path))
  expect_silent(make(p, verbose = F))
  expect_true(file.exists("input"))
  expect_true(file.exists("d"))
  expect_true(file.exists("e"))
  expect_true(all(p$output %in% cached()))
  expect_silent(prune(p[3:6,]))
  expect_true(all(p$output[3:6] %in% cached()))
  expect_false(any(p$output[c(1, 2, 7, 8)] %in% cached()))
  expect_true(file.exists("input"))
  expect_true(file.exists("d"))
  expect_false(file.exists("e"))
  expect_silent(make(p, verbose = F))
  unlink("input")
  clean(destroy=TRUE)
})

test_that("prune() removes dangling files", {
  p = example_plan("debug")
  debug_setup()
  expect_equal(cached(), character(0))
  expect_false(file.exists(cache_path))
  expect_silent(make(p, verbose = F))
  expect_true(file.exists("input"))
  expect_true(file.exists("d"))
  expect_true(file.exists("e"))
  expect_true("final" %in% cached())
  p$output[6] = "'new_d.rds'"
  expect_false(all(grepl("'d'", p$output)))
  expect_error(make(p, verbose = F))
  p$code[6] = "saveRDS(d, \"new_d.rds\")"
  expect_silent(make(p, verbose = F))
  expect_true(file.exists("input"))
  expect_true(file.exists("d"))
  expect_true(file.exists("e"))
  expect_true(file.exists("new_d.rds"))
  expect_true(all(c("'d'","'e'","'input'","'new_d.rds'") %in% cached()))
  prune(p[3:6,])
  expect_true(file.exists("input"))
  expect_false(file.exists("d"))
  expect_false(file.exists("e"))
  expect_true(file.exists("new_d.rds"))
  expect_true(file.exists(cache_path))
  expect_silent(prune(p))
  expect_silent(prune(p))
  p = data.frame(output = paste0(letters[1:26], "_"), code = "1")
  expect_silent(prune(p))
  expect_silent(prune(p))
  unlink("input")
  unlink("new_d.rds")
  clean(destroy=TRUE)
  expect_silent(prune(p))
  expect_silent(prune(p))
})
