% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{recover_cache}
\alias{recover_cache}
\title{Function recover_cache}
\usage{
recover_cache(path = drake::default_cache_path(),
  type = drake::default_cache_type(),
  short_hash_algo = drake::default_short_hash_algo(),
  long_hash_algo = drake::default_long_hash_algo())
}
\arguments{
\item{path}{file path of the cache}

\item{type}{character scalar, type of the drake cache.
Must be among the list of supported caches
in \code{\link{cache_types}()}.}

\item{short_hash_algo}{short hash algorithm for the cache.
See \code{\link{default_short_hash_algo}()} and
\code{\link{make}()}}

\item{long_hash_algo}{long hash algorithm for the cache.
See \code{\link{default_long_hash_algo}()} and
\code{\link{make}()}}
}
\description{
Load an existing drake files system cache if it exists
and create a new one otherwise.
Do not use for in-memory caches such as
\code{storr_environment()}.
}
\examples{
\dontrun{
load_basic_example()
make(my_plan)
x <- recover_cache(".drake")
}
}
\seealso{
\code{\link{new_cache}}, \code{\link{this_cache}},
\code{\link{get_cache}}
}
