% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecate.R
\name{status}
\alias{status}
\title{Deprecated function \code{status}}
\usage{
status(..., list = character(0), no_imported_objects = FALSE,
  imported_files_only = logical(0), path = getwd(), search = TRUE)
}
\arguments{
\item{...}{objects to load from the cache, as names (unquoted)
or character strings (quoted). Similar to \code{...} in
\code{\link{remove}(...)}.}

\item{list}{character vector naming objects to be loaded from the
cache. Similar to the \code{list} argument of \code{\link{remove}()}.}

\item{no_imported_objects}{logical, whether to only return information
about imported files and targets with commands (i.e. whether to ignore
imported objects that are not files).}

\item{imported_files_only}{logical, deprecated.
Same as \code{no_imported_objects}.
Use the \code{no_imported_objects} argument instead.}

\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.}

\item{search}{If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.}
}
\value{
Either the build progress of each target given (from the last
call to \code{\link{make}()} or \code{\link{make}()}), or if no
targets are specified, a data frame containing the build progress
of the last session.
In the latter case, only finished targets are listed.

Either a named logical indicating whether the given
targets or cached or a character vector listing all cached
items, depending on whether any targets are specified
}
\description{
Use \code{\link{progress}()} instead.
Gets the build progress (overall or individual targets)
of the last call to \code{\link{make}()}.
Objects that drake imported, built, or attempted
to build are listed as \code{"finished"} or \code{"in progress"}.
Skipped objects are not listed.
}
\examples{
\dontrun{
load_basic_example()
make(my_plan)
status() # Deprecated. Use progress() instead.
status(small, large)
status(list = c("small", "large"))
status(no_imported_objects = TRUE)
}
}
\seealso{
\code{\link{progress}},
\code{\link{built}}, \code{\link{imported}},
\code{\link{readd}}, \code{\link{workplan}}, \code{\link{make}}
}
