% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.R
\name{plan_summaries}
\alias{plan_summaries}
\title{Generate a workflow plan data frame for summarizing
multiple analyses of multiple datasets multiple ways.}
\usage{
plan_summaries(plan, analyses, datasets, gather = rep("list", nrow(plan)))
}
\arguments{
\item{plan}{workflow plan data frame with commands for the summaries.
Use the \code{analysis__} and \code{dataset__} wildcards
just like the \code{dataset__} wildcard in \code{\link[=analyses]{analyses()}}.}

\item{analyses}{workflow plan data frame of analysis instructions}

\item{datasets}{workflow plan data frame with instructions to make
or import the datasets.}

\item{gather}{Character vector, names of functions to gather the
summaries. If not \code{NULL}, the length must be the number of
rows in the \code{plan}. See the \code{\link[=gather]{gather()}} function
for more.}
}
\value{
An evaluated workflow plan data frame of instructions
for computing summaries of analyses and datasets.
analyses of multiple datasets in multiple ways.
}
\description{
Uses wildcards to create a new
workflow plan data frame from a template data frame.
}
\examples{
# Create the part of the workflow plan data frame for the datasets.
datasets <- drake_plan(
  small = simulate(5),
  large = simulate(50))
# Create a template workflow plan containing the analysis methods.
methods <- drake_plan(
  regression1 = reg1(dataset__),
  regression2 = reg2(dataset__))
# Generate the part of the workflow plan to analyze the datasets.
analyses <- plan_analyses(methods, datasets = datasets)
# Create a template workflow plan dataset with the
# types of summaries you want.
summary_types <- drake_plan(
  summ = summary(analysis__),
  coef = coefficients(analysis__))
# Evaluate the appropriate wildcards to encode the summary targets.
plan_summaries(summary_types, analyses, datasets, gather = NULL)
plan_summaries(summary_types, analyses, datasets)
plan_summaries(summary_types, analyses, datasets, gather = "list")
summs <- plan_summaries(
  summary_types, analyses, datasets, gather = c("list", "rbind"))
# For the final workflow plan, row bind the pieces together.
my_plan <- rbind(datasets, analyses, summs)
my_plan
}
\seealso{
\code{\link[=plan_analyses]{plan_analyses()}}, \code{\link[=make]{make()}},
\code{\link[=drake_plan]{drake_plan()}}
}
