% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_drake_graph.R
\name{render_drake_graph}
\alias{render_drake_graph}
\title{Render a visualization using the data frames
generated by \code{\link[=drake_graph_info]{drake_graph_info()}}.}
\usage{
render_drake_graph(graph_info, file = character(0),
  layout = "layout_with_sugiyama", direction = "LR", hover = TRUE,
  main = graph_info$default_title, selfcontained = FALSE,
  navigationButtons = TRUE, ncol_legend = 1, ...)
}
\arguments{
\item{graph_info}{list of data frames generated by
\code{\link[=drake_graph_info]{drake_graph_info()}}.
There should be 3 data frames: \code{nodes}, \code{edges},
and \code{legend_nodes}.}

\item{file}{Name of HTML file to save the graph.
If \code{NULL} or \code{character(0)},
no file is saved and the graph is rendered and displayed within R.}

\item{layout}{name of an igraph layout to use,
such as 'layout_with_sugiyama'
or 'layout_as_tree'.
Be careful with 'layout_as_tree': the graph is a directed
acyclic graph, but not necessarily a tree.}

\item{direction}{an argument to \code{visNetwork::visHierarchicalLayout()}
indicating the direction of the graph.
Options include 'LR', 'RL', 'DU', and 'UD'.
At the time of writing this, the letters must be capitalized,
but this may not always be the case ;) in the future.}

\item{hover}{logical, whether to show the command that generated the target
when you hover over a node with the mouse. For imports, the label does not
change with hovering.}

\item{main}{character string, title of the graph}

\item{selfcontained}{logical, whether
to save the \code{file} as a self-contained
HTML file (with external resources base64 encoded) or a file with
external resources placed in an adjacent directory. If \code{TRUE},
pandoc is required.}

\item{navigationButtons}{logical, whether to add navigation buttons with
\code{visNetwork::visInteraction(navigationButtons = TRUE)}}

\item{ncol_legend}{number of columns in the legend nodes.
To remove the legend entirely, set \code{ncol_legend} to \code{NULL} or \code{0}.}

\item{...}{arguments passed to \code{visNetwork()}.}
}
\value{
A \code{visNetwork} graph.
}
\description{
This function is called inside
\code{\link[=vis_drake_graph]{vis_drake_graph()}}, which typical users
call more often.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_mtcars_example() # Get the code with drake_example("mtcars").
# Instead of jumpting right to vis_drake_graph(), get the data frames
# of nodes, edges, and legend nodes.
config <- drake_config(my_plan) # Internal configuration list
vis_drake_graph(config) # Jump straight to the interactive graph.
# Get the node and edge info that vis_drake_graph() just plotted:
graph <- drake_graph_info(config)
# You can pass the data frames right to render_drake_graph()
# (as in vis_drake_graph()) or you can create
# your own custom visNewtork graph.
render_drake_graph(graph, width = '100\%') # Width is passed to visNetwork.
# Optionally visualize clusters.
config$plan$large_data <- grepl("large", config$plan$target)
graph <- drake_graph_info(
  config, group = "large_data", clusters = c(TRUE, FALSE))
render_drake_graph(graph)
# You can even use clusters given to you for free in the `graph$nodes`
# data frame.
graph <- drake_graph_info(
  config, group = "status", clusters = "imported")
render_drake_graph(graph)
})
}
}
\seealso{
\code{\link[=vis_drake_graph]{vis_drake_graph()}}, \code{\link[=sankey_drake_graph]{sankey_drake_graph()}},
\code{\link[=static_drake_graph]{static_drake_graph()}}
}
