% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-hpc.R
\name{drake_hpc_template_file}
\alias{drake_hpc_template_file}
\title{Write a template file for deploying
work to a cluster / job scheduler.}
\usage{
drake_hpc_template_file(file = drake::drake_hpc_template_files(),
  to = getwd(), overwrite = FALSE)
}
\arguments{
\item{file}{Name of the template file, including the "tmpl" extension.}

\item{to}{Character vector, where to write the file.}

\item{overwrite}{Logical, whether to overwrite an existing file of the
same name.}
}
\value{
\code{NULL} is returned,
but a batchtools template file is written.
}
\description{
See the example files from
\code{\link[=drake_examples]{drake_examples()}} and \code{\link[=drake_example]{drake_example()}}
for example usage.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_mtcars_example() # Get the code with drake_example("mtcars").
# List the available template files.
drake_hpc_template_files()
# Write a SLURM template file from the SLURM example.
drake_hpc_template_file("slurm_batchtools.tmpl") # Writes slurm_batchtools.tmpl.
# library(future.batchtools) # nolint
# future::plan(batchtools_slurm, template = "slurm_batchtools.tmpl") # nolint
# make(my_plan, parallelism = "future", jobs = 2) # nolint
})
}
}
\seealso{
\code{\link[=drake_hpc_template_files]{drake_hpc_template_files()}},
\code{\link[=drake_examples]{drake_examples()}}, \code{\link[=drake_example]{drake_example()}},
\code{\link[=shell_file]{shell_file()}}
}
