% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drake_plan_helpers.R
\name{target}
\alias{target}
\title{Customize a target in \code{\link[=drake_plan]{drake_plan()}}.
\lifecycle{maturing}}
\usage{
target(command = NULL, transform = NULL, ...)
}
\arguments{
\item{command}{The command to build the target.}

\item{transform}{A call to \code{\link[=map]{map()}}, \code{\link[=split]{split()}},
\code{\link[=cross]{cross()}}, or \code{\link[=combine]{combine()}} to create or aggregate
multiple targets at once.
Details:
\url{https://ropenscilabs.github.io/drake-manual/plans.html#large-plans}}

\item{...}{Optional columns of the plan for a given target.
See the Columns section of this help file for a selection
of special columns that \code{drake} understands.}
}
\value{
A one-row workflow plan data frame with the named
arguments as columns.
}
\description{
Must be called inside \code{\link[=drake_plan]{drake_plan()}}.
Invalid otherwise.
}
\section{Columns}{

\code{\link[=drake_plan]{drake_plan()}} creates a special data frame. At minimum, that data frame
must have columns \code{target} and \code{command} with the target names and the
R code chunks to build them, respectively.

You can add custom columns yourself, either with \code{target()} (e.g.
\code{drake_plan(y = target(f(x), transform = map(c(1, 2)), format = "fst"))})
or by appending columns post-hoc (e.g. \code{plan$col <- vals}).

Some of these custom columns are special. They are optional,
but \code{drake} looks for them at various points in the workflow.
\itemize{
\item \code{transform}: a call to \code{\link[=map]{map()}}, \code{\link[=split]{split()}}, \code{\link[=cross]{cross()}}, or
\code{\link[=combine]{combine()}} to create and manipulate large collections of targets.
Details: (\url{https://ropenscilabs.github.io/drake-manual/plans.html#large-plans}). # nolint
\item \code{format}: set a storage format to save big targets more efficiently.
Most formats are faster than ordinary storage, and they consume
far less memory. Available formats:
\itemize{
\item \code{"fst"}: save big data frames fast. Requirements:
\enumerate{
\item The \code{fst} package must be installed.
\item The target's value must be a plain data frame. If it is not a
plain data frame (for example, a tibble or data.table)
then drake will coerce it to a plain data frame with
\code{as.data.frame()}.
All non-data-frame-specific attributes are lost
when \code{drake} saves the target.
}
\item \code{"fst_dt"}: Like \code{"fst"} format, but for \code{data.table} objects.
Requirements:
\enumerate{
\item The \code{data.table} and \code{fst} packages must be installed.
\item The target's value must be a data.table object. If it is not a
data.table object (for example, a data frame or tibble)
then drake will coerce it to a data.table object using
\code{data.table::as.data.table()}.
All non-data-table-specific attributes are lost
when \code{drake} saves the target.
}
\item \code{"keras"}: save Keras models as HDF5 files.
Requires the \code{keras} package.
\item \code{"rds"}: save any object. This is similar to the default storage
except we avoid creating a serialized copy of
the entire target in memory.
Requires R >= 3.5.0 so drake can use ALTREP.
}
\item \code{trigger}: rule to decide whether a target needs to run.
It is recommended that you define this one with \code{target()}.
Details: \url{https://ropenscilabs.github.io/drake-manual/triggers.html}.
\item \code{hpc}: logical values (\code{TRUE}/\code{FALSE}/\code{NA}) whether to send each target
to parallel workers.
Visit \url{https://ropenscilabs.github.io/drake-manual/hpc.html#selectivity}
to learn more.
\item \code{resources}: target-specific lists of resources for a computing cluster.
See
\url{https://ropenscilabs.github.io/drake-manual/hpc.html#advanced-options}
for details.
\item \code{caching}: overrides the \code{caching} argument of \code{\link[=make]{make()}} for each target
individually. Possible values:
\itemize{
\item "master": tell the master process to store the target in the cache.
\item "worker": tell the HPC worker to store the target in the cache.
\item NA: default to the \code{caching} argument of \code{\link[=make]{make()}}.
}
\item \code{elapsed} and \code{cpu}: number of seconds to wait for the target to build
before timing out (\code{elapsed} for elapsed time and \code{cpu} for CPU time).
\item \code{retries}: number of times to retry building a target
in the event of an error.
\item \code{seed}: an optional pseudo-random number generator (RNG)
seed for each target. \code{drake} usually comes up with its own
unique reproducible target-specific seeds using the global seed
(the \code{seed} argument to \code{\link[=make]{make()}} and \code{\link[=drake_config]{drake_config()}})
and the target names, but you can overwrite these automatic seeds.
\code{NA} entries default back to \code{drake}'s automatic seeds.
}
}

\section{Keywords}{

\code{\link[=drake_plan]{drake_plan()}} understands special keyword functions for your commands.
With the exception of \code{\link[=target]{target()}}, each one is a proper function
with its own help file.
\itemize{
\item \code{\link[=target]{target()}}: give the target more than just a command.
Using \code{\link[=target]{target()}}, you can apply a transformation
(examples: \url{https://ropenscilabs.github.io/drake-manual/plans.html#large-plans}), # nolint
supply a trigger (\url{https://ropenscilabs.github.io/drake-manual/triggers.html}), # nolint
or set any number of custom columns.
\item \code{\link[=map]{map()}}: create multiple targets. Called inside \code{\link[=target]{target()}}.
\item \code{\link[=split]{split()}}: create a target for each subset of data.
Called inside \code{\link[=target]{target()}}.
\item \code{\link[=cross]{cross()}}: create a target for each combination of values.
Called inside \code{\link[=target]{target()}}.
\item \code{\link[=combine]{combine()}}: aggregate groups of targets into other targets.
Called inside \code{\link[=target]{target()}}.
\item \code{\link[=file_in]{file_in()}}: declare an input file dependency.
\item \code{\link[=file_out]{file_out()}}: declare an output file to be produced
when the target is built.
\item \code{\link[=knitr_in]{knitr_in()}}: declare a \code{knitr} file dependency such as an
R Markdown (\code{*.Rmd}) or R LaTeX (\code{*.Rnw}) file.
\item \code{\link[=ignore]{ignore()}}: force \code{drake} to entirely ignore a piece of code:
do not track it for changes and do not analyze it for dependencies.
\item \code{\link[=no_deps]{no_deps()}}: tell \code{drake} to not track the dependencies
of a piece of code. \code{drake} still tracks the code itself for changes.
\item \code{\link[=drake_envir]{drake_envir()}}: get the environment where drake builds targets.
Intended for advanced custom memory management.
}
}

\examples{
# Use target() to create your own custom columns in a drake plan.
# See ?triggers for more on triggers.
drake_plan(
  website_data = target(
    download_data("www.your_url.com"),
    trigger = "always",
    custom_column = 5
  ),
  analysis = analyze(website_data)
)
models <- c("glm", "hierarchical")
plan <- drake_plan(
  data = target(
    get_data(x),
    transform = map(x = c("simulated", "survey"))
  ),
  analysis = target(
    analyze_data(data, model),
    transform = cross(data, model = !!models, .id = c(x, model))
  ),
  summary = target(
    summarize_analysis(analysis),
    transform = map(analysis, .id = c(x, model))
  ),
  results = target(
    bind_rows(summary),
    transform = combine(summary, .by = data)
  )
)
plan
if (requireNamespace("styler", quietly = TRUE)) {
  print(drake_plan_source(plan))
}
}
\seealso{
\code{\link[=drake_plan]{drake_plan()}}, \code{\link[=make]{make()}}
}
