% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{drake-package}
\alias{drake-package}
\alias{drake}
\title{drake: A pipeline toolkit for reproducible computation at scale.}
\description{
drake is a pipeline toolkit
(\url{https://github.com/pditommaso/awesome-pipeline})
and a scalable, R-focused solution for reproducibility
and high-performance computing.
}
\examples{
\dontrun{
isolate_example("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
library(drake)
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Build everything.
plot(my_plan) # fast call to vis_drake_graph()
make(my_plan) # Nothing is done because everything is already up to date.
reg2 = function(d) { # Change one of your functions.
  d$x3 = d$x^3
  lm(y ~ x3, data = d)
}
make(my_plan) # Only the pieces depending on reg2() get rebuilt.
# Write a flat text log file this time.
make(my_plan, cache_log_file = TRUE)
# Read/load from the cache.
readd(small)
loadd(large)
head(large)
}
# Dynamic branching
plan <- drake_plan(
  w = c("a", "a", "b", "b"),
  x = seq_len(4),
  y = target(x + 1, dynamic = map(x)),
  z = target(list(y = y, w = w), dynamic = group(y, .by = w))
)
make(plan)
subtargets(y)
readd(subtargets(y)[1], character_only = TRUE)
readd(subtargets(y)[2], character_only = TRUE)
readd(subtargets(z)[1], character_only = TRUE)
readd(subtargets(z)[2], character_only = TRUE)
})
}
}
\references{
\url{https://github.com/ropensci/drake}
}
\author{
William Michael Landau \email{will.landau@gmail.com}
}
