% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_sample_n.R
\name{draw_sample_n}
\alias{draw_sample_n}
\title{Draw Samples with the Desired Properties from a Data Set}
\usage{
draw_sample_n(
  dist,
  n,
  skew,
  kurts,
  location = 0,
  delta_var = 0,
  output_name = c("sample", "default")
)
}
\arguments{
\item{dist}{data frame:consists of id and scores with no missing}

\item{n}{numeric: desired sample size}

\item{skew}{numeric: the skewness value}

\item{kurts}{numeric: the kurtosis value}

\item{location}{numeric: the value for adjusting mean (default is 0).}

\item{delta_var}{numeric: the value for adjusting variance (default is 0).}

\item{output_name}{character: a vector of two components.
The first component is the name of the output file,
user can change the second component.}
}
\value{
This function returns a \code{list} including following:
\itemize{
\item a matrix: Descriptive statistics of the given data,
                the reference vector and the sample.
\item a data frame: The id's and scores of the sample
\item graph: Histograms for the “data” and the “sample”
}
}
\description{
A function to sample data with desired properties.
}
\details{
The desired skewness and kurtosis values cannot be met while the function
execution is faster. The attributes of kurtosis are in doubt.
This is because the range of kurtosis is greater than the skewness.
For \code{location} values can be entered to position the midpoint or mean of the
distribution differently. For \code{delta_var} the value can be entered for
how much will increase or decrease the variability of reference distribution.
In other words, the reference distribution is generated as the standard normal distribution,
unless the user changes the default values of the \code{location} and \code{delta_var} arguments.
}
\examples{
# Example data provided with package
data(example_data)
\dontrun{
# Draw a sample based on Score_1
# draw_sample_n(dist=example_data[,c(1,2)],n=200,skew = 0,kurts = 0, location=0, delta_var=0,
# output_name = c("sample", "4"))
# Draw a sample based on Score_2 (location par)
# draw_sample_n(dist=example_data[,c(1,3)],n=200,skew = 1,kurts = 1,location=-0.5,delta_var=0,
# output_name = c("sample", "5"))
# Draw a sample based on Score_2 (delta_var par)
# draw_sample_n(dist=example_data[,c(1,3)],n=200,skew = 0.5,kurts = 0.4,location=0,delta_var=0.3,
# output_name = c("sample", "6"))
}
}
\references{
Fleishman AI (1978). A Method for Simulating Non-normal Distributions.
 \emph{Psychometrika, 43, 521-532.} \doi{10.1007/BF02293811}.

Fialkowski, A. C.  (2018). SimMultiCorrData: Simulation of Correlated Data
with Multiple #' Variable Types.  R package version 0.2.2. Retrieved from
https://cran.r-project.org/web/packages/SimMultiCorrData/index.html
}
