% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglogistic5.R
\name{loglogistic5_gradient}
\alias{loglogistic5_gradient}
\alias{loglogistic5_hessian}
\alias{loglogistic5_gradient_hessian}
\title{5-parameter log-logistic function gradient and Hessian}
\usage{
loglogistic5_gradient(x, theta)

loglogistic5_hessian(x, theta)

loglogistic5_gradient_hessian(x, theta)
}
\arguments{
\item{x}{numeric vector at which the function is to be evaluated.}

\item{theta}{numeric vector with the five parameters in the form
\code{c(alpha, delta, eta, phi, nu)}.}
}
\value{
Gradient or Hessian evaluated at the specified point.
}
\description{
Evaluate at a particular set of parameters the gradient and Hessian of the
5-parameter log-logistic function.
}
\details{
The 5-parameter log-logistic function \verb{f(x; theta)} is defined here as

\verb{g(x; theta) = (x^eta / (x^eta + nu * phi^eta))^(1 / nu)}
\verb{f(x; theta) = alpha + delta g(x; theta)}

where \code{x >= 0}, \code{theta = c(alpha, delta, eta, phi, nu)}, \code{eta > 0},
\code{phi > 0}, and \code{nu > 0}.
}
