% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dreamerr.R
\docType{package}
\name{dreamerr-package}
\alias{dreamerr}
\alias{dreamerr-package}
\title{Error Handling Made Easy}
\description{
The main purpose of this package is twofold: i) to facilitate the developer's life, and ii) to provide to the users meaningful, useful error messages. These objectives are accomplished with a single function: \code{\link[dreamerr]{check_arg}}. That function checks the arguments given by the user: it offers a compact syntax such that complex arguments can be simply stated by the developer. In turn, if the user provides an argument of the wrong type then an informative error message will be buit, stating the expected type and where the error comes from--saving the user quite some time in debugging.
}
\details{
Thus you can very easily make your package look professional with \code{\link[dreamerr]{check_arg}} (checking arguments properly \emph{is} professional).

It also offers a set of small tools to provide informative messages to the users. See \code{\link[dreamerr]{stop_up}} and \code{\link[dreamerr:stop_up]{warn_up}} to throw errors and warnings in the appropriate location. There are many tools to form messages: \code{\link[dreamerr]{enumerate_items}} to form textual list of elements (with many options including conjugating verbs, etc...), \code{\link[dreamerr]{plural}} to conjugate verbs depending on the argument, and \code{\link[dreamerr:n_times]{n_letter}}, \code{\link[dreamerr:n_times]{n_th}}, \code{\link[dreamerr]{n_times}} to write integers in words (which usually looks nicer).

To sum up in a few words, this package was created to enhance the user experience and facilitate package development.
}
\seealso{
Useful links:
\itemize{
  \item Report bugs at \url{https://github.com/lrberge/dreamerr/issues}
}

}
\author{
\strong{Maintainer}: Laurent Berge \email{laurent.berge@uni.lu}

}
