% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tauSurface.R
\name{getTauSurface}
\alias{getTauSurface}
\title{Compute interaction index surface and confidence intervals}
\usage{
getTauSurface(fit, data = NULL, addCI = TRUE, method = c("default",
  "boot"), level = 0.95, niter = 100, resample = c("all", "mono",
  "stratified"), seed = NULL, ...)
}
\arguments{
\item{fit}{A \code{HarbronFit} object returned by 
\code{\link{fitModel}}.}

\item{data}{Dose combinations to compute interaction index for. If NULL 
(default), taken from the \code{fit} object.}

\item{addCI}{Whether confidence intervals need to be computed.}

\item{method}{Which method to use to calculate confidence intervals: 
"default" for Wald-type or "boot" for non-parametric bootstrap.}

\item{level}{The confidence level required for the confidence intervals 
(default is 0.95).}

\item{niter}{Number of bootstrap samples to use.}

\item{resample}{Resampling method for bootstrap. Either "all" (default) for 
resampling from all data, "mono" for separately resampling monotherapy and 
combination data, or "stratified" for resampling at each dose combination 
separately. Note that the latter method is not meaningful if there are no 
replicates in the data.}

\item{seed}{Random seed to use for bootstrap}

\item{...}{Further parameters that are passed to \code{\link{getBootTaus}}.}
}
\value{
An object of class "tauSurface" which is essentially a list with 
the following components: data frame with interaction index (tau) estimates,
standard errors and point-wise confidence intervals, formulas for computing 
tau at any given dose (only for models with continuous functions used to 
define tau), and details on the tau specification from the \code{fit}. In 
addition, if the "boot" method was used, all the bootstrap estimates are 
returned and can be accessed with \code{\link{bootstrapCoefs}}.
}
\description{
Computes estimates and confidence intervals for the interaction surface for 
all dose combinations.
}
\seealso{
\code{\link{plot.tauSurface}}, \code{\link{contour.tauSurface}} for
visual representation of the tau surface.
}
\author{
Maxim Nazarov
}
