% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_fun.R
\name{what_week}
\alias{what_week}
\title{What week is it?}
\usage{
what_week(when = Sys.time(), unit = "year", as_integer = FALSE)
}
\arguments{
\item{when}{Date (as a scalar or vector).
Default: \code{when = NA}. 
Using \code{as.Date(when)} to convert strings into dates, 
and \code{Sys.Date()}, if \code{when = NA}.}

\item{unit}{Character: Unit of week?
Possible values are \code{"month", "year"}. 
Default: \code{unit = "year"} (for week within year).}

\item{as_integer}{Boolean: Return as integer? 
Default: \code{as_integer = FALSE}.}
}
\description{
\code{what_week} provides a satisficing version of 
to determine the week corresponding to a given date.
}
\details{
\code{what_week} returns the week   
of \code{when} or \code{Sys.Date()} 
(as a name or number).
}
\examples{
what_week()
what_week(as_integer = TRUE)

# Other dates/times:
d1 <- as.Date("2019-08-23")
what_week(when = d1, unit = "year")
what_week(when = d1, unit = "month")

# Work with vectors (when as characters):
ds <- c("2020-01-01", "2020-02-29", "2020-12-24", "2020-12-31")
what_week(when = ds)
what_week(when = ds, unit = "month", as_integer = TRUE)
what_week(when = ds, unit = "year", as_integer = TRUE)
 
}
\seealso{
\code{what_day()} function to obtain days; 
\code{what_date()} function to obtain dates; 
\code{cur_time()} function to print the current time; 
\code{cur_date()} function to print the current date; 
\code{now()} function of the \strong{lubridate} package; 
\code{Sys.time()} function of \strong{base} R.

Other date and time functions: 
\code{\link{cur_date}()},
\code{\link{cur_time}()},
\code{\link{what_date}()},
\code{\link{what_day}()},
\code{\link{what_month}()},
\code{\link{what_time}()},
\code{\link{what_year}()}
}
\concept{date and time functions}
