% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_fun.R
\name{what_day}
\alias{what_day}
\title{What day (of the week) is it?}
\usage{
what_day(when = Sys.time(), abbr = FALSE)
}
\arguments{
\item{when}{Date (as a scalar or vector).
Default: \code{when = NA}. 
Using \code{as.Date(when)} to convert strings into dates, 
and \code{Sys.Date()}, if \code{when = NA}.}

\item{abbr}{Boolean: Return abbreviated?
Default: \code{abbr = FALSE}.}
}
\description{
\code{what_day} provides a satisficing version of 
to determine the day of the week 
corresponding to a given date.
}
\details{
\code{what_day} returns the weekday  
of \code{when} or \code{Sys.Date()} 
(as a name).
}
\examples{
what_day()
what_day(abbr = TRUE)

# Work with vectors (when as characters):
ds <- c("2020-01-01", "2020-02-29", "2020-12-24", "2020-12-31")
what_day(when = ds)
what_day(when = ds, abbr = TRUE)

}
\seealso{
\code{what_date()} function to obtain dates; 
\code{what_time()} function to obtain times; 
\code{cur_time()} function to print the current time; 
\code{cur_date()} function to print the current date; 
\code{now()} function of the \strong{lubridate} package; 
\code{Sys.time()} function of \strong{base} R.

Other date and time functions: 
\code{\link{cur_date}()},
\code{\link{cur_time}()},
\code{\link{what_date}()},
\code{\link{what_month}()},
\code{\link{what_time}()},
\code{\link{what_week}()},
\code{\link{what_year}()}
}
\concept{date and time functions}
