% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_fun.R
\name{text_to_words}
\alias{text_to_words}
\title{text_to_words splits a string of text \code{x} 
(consisting of one or more character strings) 
into a vector of its constituting words.}
\usage{
text_to_words(x)
}
\arguments{
\item{x}{A string of text (required), 
typically a character vector.}
}
\description{
\code{text_to_words} removes all (standard) punctuation marks 
and empty spaces in the resulting parts, 
before returning a vector of the remaining character symbols 
(as the words).
}
\details{
Internally, \code{text_to_words} uses \code{\link{strsplit}} to 
split strings.
}
\examples{
# Default: 
x <- c("Hello!", "This is a 1st sentence.", "This is the 2nd sentence.", "The end.")
text_to_words(x)

}
\seealso{
\code{\link{text_to_sentences}} for splitting text into a vector of sentences;  
\code{\link{count_words}} for counting the frequency of words; 
\code{\link{strsplit}} for splitting strings.

Other text objects and functions: 
\code{\link{Umlaut}},
\code{\link{capitalize}()},
\code{\link{caseflip}()},
\code{\link{cclass}},
\code{\link{count_chars}()},
\code{\link{count_words}()},
\code{\link{l33t_rul35}},
\code{\link{metachar}},
\code{\link{read_ascii}()},
\code{\link{text_to_sentences}()},
\code{\link{transl33t}()}
}
\concept{text objects and functions}
