% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_trend.R
\name{get_trend}
\alias{get_trend}
\title{Get Trend-Cycle}
\usage{
get_trend(daily.object, trend_length = 93, forecast = FALSE)
}
\arguments{
\item{daily.object}{Output from dsa}

\item{trend_length}{Number of neighbouring points to use, in days}

\item{forecast}{Include forecast of component}
}
\description{
Calculate the trend-cycle based on a seasonally adjusted series obtained from a seasonal adjustment object created by the dsa function
}
\details{
If not odd the parameter trend_length is set to the next highest odd number.
}
\examples{
set.seed(123)
x = daily_sim(n=4)$original # series with length 4 years
res <- dsa(x, cval=7, model=c(3,1,0),fourier_number = 13, reg.create=NULL) 
get_trend(res)
}
\seealso{
get_sa, get_original
}
\author{
Daniel Ollech
}
