% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort_itemnames.R
\name{sort_itemnames}
\alias{sort_itemnames}
\alias{order_itemnames}
\title{Sorts item names according to user-specified priority}
\usage{
sort_itemnames(x, order = "idnm")

order_itemnames(x, order = "idnm")
}
\arguments{
\item{x}{A character vector containing item names (gsed lexicon)}

\item{order}{A four-letter string specifying the sorting order.
The four letters are: \code{i} for instrument, \code{d} for domain,
\code{m} for mode and \code{n} for number. The default is
\code{"idnm"}.}
}
\value{
\code{sort_itemnames()} return a character vector with
\code{length(x)} sorted elements. \code{order_itemnames()} return
an integer vector of length \code{length(x)} with positions of
the sorted elements.
}
\description{
This function sorts the item names according to instrument,
domain, mode and number. The user can specify the sorting
order.
}
\examples{
itemnames <- c("aqigmc028", "grihsd219", "", "by1mdd157", "mdsgmd006")
sort_itemnames(itemnames)
}
\seealso{
\code{\link[=decompose_itemnames]{decompose_itemnames()}}
}
\author{
Stef van Buuren
}
