\name{forecastCovWRTtrue}
\alias{forecastCovWRTtrue}
\alias{is.forecastCovWRTdata}

\title{Compare Forecasts to True Model Output}
\description{
    Generate forecasts and compare them against the output of a true model.}
\usage{
    forecastCovWRTtrue(models, true.model, 
        pred.replications=1, simulation.args=NULL, quiet=FALSE, rng=NULL, 
	compiled=.DSEflags()$COMPILED,
        horizons=1:12, discard.before=10, trend=NULL, zero=NULL, 
	Spawn=if (exists(".SPAWN")) .SPAWN else FALSE)
    is.forecastCovWRTdata(obj)
}
\arguments{
    \item{models}{A list of objects of class TSmodel.}
    \item{true.model}{An object of class TSmodel or TSestModel.}
    \item{discard.before}{
    An integer indicating the number of points in the
    beginning of forecasts to discard for calculating covariances.}
    \item{zero}{If TRUE then forecastCov is also calculated for a forecast of zero.}
    \item{trend}{If TRUE then forecastCov is also calculated for a forecast of a linear trend.}
    \item{pred.replications}{integer indicating the number of times simulated
       data is generated.}
    \item{simulation.args}{
    A list of any arguments which should be passed to simulate
    in order to simulate the true model.}
    \item{horizons}{Horizons for which forecast covariance should be calculated.}
    \item{rng}{If specified then it is used to set RNG.}
    \item{Spawn}{If TRUE then Splus For loops are used.}
    \item{quiet}{If TRUE then some messages are not printed.}
    \item{compiled}{a logical indicating if compiled code should be
      used. (Usually true except for debugging.)}
    \item{obj}{an object.}
}
\value{
A list with the forecast covariance for supplied models on samples
generated by the given true model. This is in the element \code{forecastCov}
of the result. Other elements contain information in the arguments.
}
\details{
The true model is used to generate
data and for each generated data set the forecasts of the 
models are evaluated against the simulated data.
If trend is not null it is treated as a model output (forecast) and
should be the same dimension as a simulation of the models with 
simulation.args. If zero is not null a zero forecast is also evaluated. If 
simulating the true model requires input data then a convenient way to do this
is for true.model to be a TSestModel. Otherwise, input data should be passed
in simulation.args
}
\seealso{
\code{\link{forecastCovEstimatorsWRTdata}}
\code{\link[dse1]{simulate}}
\code{\link{EstEval}}
\code{\link{distribution}}
\code{\link{MonteCarloSimulations}}
}
\examples{
data("eg1.DSE.data.diff", package="dse1")
true.model <- estVARXls(eg1.DSE.data.diff) # A starting model TSestModel
data <- simulate(true.model)
models <- list(TSmodel(estVARXar(data)),TSmodel(estVARXls(data)))
z <-  forecastCovWRTtrue( models, true.model)
}
\concept{DSE}
\keyword{ts}

