% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normexp_mgcv.R
\name{normexp}
\alias{normexp}
\title{normexp family}
\usage{
normexp(link = list("identity", "log", "log"), s = -1)
}
\arguments{
\item{link}{three item list specifying the link for the \eqn{\mu}, \eqn{\sigma_V} and \eqn{\lambda} parameters. See details.}

\item{s}{\eqn{s=-1} for production and \eqn{s=1} for cost function.}
}
\value{
An object inheriting from class \code{general.family} of the mgcv package, which can be used in the dsfa package.
}
\description{
The normexp family implements the normal-exponential distribution in which the \eqn{\mu}, \eqn{\sigma_V} and \eqn{\lambda} can depend on additive predictors. Useable only with \code{mgcv::gam}, the additive predictors are specified via a list of formulae.
}
\details{
Used with gam to fit distributional stochastic frontier model. The function \code{gam} is from the mgcv package is called with a list containing three formulae:
\enumerate{
\item The first formula specifies the response on the left hand side and the structure of the additive predictor for \eqn{\mu} parameter on the right hand side. Link function is "identity".
\item The second formula is one sided, specifying the additive predictor for the  \eqn{\sigma_V} on the right hand side. Link function is "log".
\item The third formula  is one sided, specifying the additive predictor for the  \eqn{\lambda} on the right hand side. Link function is "log".
}
The fitted values and linear predictors for this family will be three column matrices. The first column is the \eqn{\mu}, the second column is the \eqn{\sigma_V}, the third column is \eqn{\lambda}.
}
\examples{
#Set seed, sample size and type of function
set.seed(1337)
N=500 #Sample size
s=-1 #Set to production function

#Generate covariates
x1<-runif(N,-1,1); x2<-runif(N,-1,1); x3<-runif(N,-1,1)
x4<-runif(N,-1,1); x5<-runif(N,-1,1)

#Set parameters of the distribution
mu=2+0.75*x1+0.4*x2+0.6*x2^2+6*log(x3+2)^(1/4) #production function parameter
sigma_v=exp(-1.5+0.75*x4) #noise parameter
lambda=exp(-1+sin(2*pi*x5)) #inefficiency parameter

#Simulate responses and create dataset
y<-rnormexp(n=N, mu=mu, sigma_v=sigma_v, lambda=lambda, s=s)
dat<-data.frame(y, x1, x2, x3, x4, x5)

#Write formulae for parameters
mu_formula<-y~x1+x2+I(x2^2)+s(x3, bs="ps")
sigma_V_formula<-~1+x4
lambda_formula<-~1+s(x5, bs="ps")

#Fit model
model<-mgcv::gam(formula=list(mu_formula, sigma_V_formula, lambda_formula),
                 data=dat, family=normexp(s=s), optimizer = c("efs"))

#Model summary
summary(model)

#Smooth effects
#Effect of x3 on the predictor of the production function
plot(model,select=1) #Estimated function
lines(x3[order(x3)], 6*log(x3[order(x3)]+2)^(1/4)-
      mean(6*log(x3[order(x3)]+2)^(1/4)),col=2) #True effect

#Effect of x5 on the predictor of the inefficiency
plot(model,select=2) #Estimated function
lines(x5[order(x5)], -1+sin(2*pi*x5)[order(x5)]-
      mean(-1+sin(2*pi*x5)),col=2) #True effect

}
\references{
\itemize{
\item \insertRef{schmidt2022mvdsfm}{dsfa}
\item \insertRef{wood2017generalized}{dsfa}
\item \insertRef{meeusen1977efficiency}{dsfa}
\item \insertRef{kumbhakar2015practitioner}{dsfa}
\item \insertRef{schmidt2020analytic}{dsfa}
}
}
