% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsp.R
\name{rsp}
\alias{rsp}
\title{rsp function}
\usage{
rsp(x, link = "identity", a = 0, b = 1, inv = FALSE, deriv = 0)
}
\arguments{
\item{x}{vector of quantiles.}

\item{link}{specifying the type of link function.\cr
\code{identitity} = Identity link function \cr
\code{log} = Log link function \cr
\code{glogit} = Generalized logit link function with parameters \code{a} and \code{b} \cr}

\item{a}{numeric min value for \code{glogit} link function.}

\item{b}{numeric  max value for \code{glogit} link function.}

\item{inv}{logical; if TRUE, evaluate link function and its derivatives.}

\item{deriv}{derivative of order \code{deriv}. Available are \code{0}, \code{2} and \code{4}.}
}
\value{
Mostly internal function. Returns a vector of the corresponding function evaluated at x with its derivatives.
}
\description{
Response function and inverse response function (link function).
}
\details{
The link functions are defined as follows:\cr
\code{identitity}: \eqn{g(x)=x} and thus the response function is \eqn{g^{-1}(x)=x}. \cr
\code{log}: \eqn{g(x)=log(x)} and thus the response function is \eqn{g^{-1}(x)=exp(x)}. \cr
\code{glogit}: \eqn{g(x)=log(\frac{x-a}{b-a}/(1-\frac{x-a}{b-a}))} and thus the response function is \eqn{g^{-1}(x)=\frac{exp(x)}{1+exp(x)} \cdot (b-a)+a}. \cr
}
\examples{
rsp(x=5, link="glogit", a=0, b=1, inv=FALSE, deriv=4)
rsp(x=0.5, link="glogit", a=0, b=1, inv=TRUE, deriv=4)

}
