% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistic-wauc.R
\name{wauc_from_os}
\alias{wauc_from_os}
\title{Weighted AUC from Outlier Scores}
\usage{
wauc_from_os(os_train, os_test)
}
\arguments{
\item{os_train}{Outlier scores in training set.}

\item{os_test}{Outlier scores in test set.}
}
\value{
The value (scalar) of the weighted AUC given the weighting scheme.
}
\description{
Computes the weighted AUC with the weighting scheme described in
Kamulete, V. M. (2021). This assumes that the training set is the reference
distribution and specifies a particular functional form to derive weights
from threshold scores.
}
\examples{
\donttest{
library(dsos)
set.seed(12345)
os_train <- runif(n = 100)
os_test <- runif(n = 100)
test_stat <- wauc_from_os(os_train, os_test)
}

}
\references{
Kamulete, V. M. (2021).
\emph{Test for non-negligible adverse shifts}.
arXiv preprint arXiv:2107.02990.
}
\concept{statistic}
