% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.coverage.R
\name{run.coverage}
\alias{run.coverage}
\title{run.coverage}
\usage{
run.coverage(design, reps = 10, save.transects = "", quiet = FALSE)
}
\arguments{
\item{design}{an object which inherits from the Survey.Design
class.}

\item{reps}{the number of times you wish the coverage simulation
to be carried out.}

\item{save.transects}{a directory where the shapefiles for the
transects can be saved. The shapefile names will be S1, S2, ...
existing files in the directory will not be overwritten.}

\item{quiet}{when TRUE no progress counter is displayed.}
}
\value{
this function returns the survey design object passed in
and it will now include the coverage and design statistics.
}
\description{
This function can be used to assess the coverage of
a design and also assess design statistics, such as how the number
of samplers, the line length, trackline length or percentage
coverage varies between surveys generated from the same design.
It generates the specified number of surveys from the
design and looks to see which of the coverage grid points, a
systematic grid of points across the survey region, are included
in each survey. When calculating coverage scores if more than
one sampler falls on a grid point then that grid point gets
allocated the appropriate count. These counts are then averaged
over the number of surveys which have been generated. At the same
time it records the relevant statistics for the design. While 100
repetitions may be sufficient to get an idea of design statistics
1000 or even more repetitions may be needed to gain a good
representation of the coverage scores across the study region.
}
\details{
See ?make.design for example code.
}
\seealso{
\link{make.design}
}
