% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dssd-package.R
\docType{package}
\name{dssd-package}
\alias{dssd-package}
\alias{dssd}
\title{Distance Sampling Survey Design (dssd)}
\description{
Creates survey designs for distance sampling surveys. These
 designs can be assessed for various effort and coverage statistics.
 Once the user is satisfied with the design characteristics they can
 generate a set of transects to use in their distance sampling survey.
 Many of the designs implemented in this R package were first made
 available in our 'Distance' for Windows software and are detailed in
 Chapter 7 of Advanced Distance Sampling, Buckland et. al. (2008,
 ISBN-13: 978-0199225873).
}
\details{
The main functions in this package are: \link{make.region}, \link{make.design}, \link{generate.transects} and \link{run.coverage}. See also \link{write.transects} for examples of how to export surveys generated by dssd.

Further information on distance sampling methods and example code is available at \url{http://distancesampling.org/R/}.

We are also in the process of setting up a new area of the website for vignettes / example code at \url{http://examples.distancesampling.org }. While this is being developed dssd vignettes can still be found within this package.

For help with distance sampling and this package, there is a Google Group \url{https://groups.google.com/forum/#!forum/distance-sampling}.
}
\author{
Laura Marshall <lhm@st-and.ac.uk>
}
\keyword{package}
