% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baseline_fn.R
\name{baseline_exprs}
\alias{baseline_exprs}
\title{Estimate the offset terms.}
\usage{
baseline_exprs(Y, pure_samples, markers)
}
\arguments{
\item{Y}{The expression matrix. Data frame or matrix. Each row contains expression measurements for a particular sample. Each columm contains the measurements of the same gene over all individuals.}

\item{pure_samples}{The pure sample indicies. List of vectors. The i-th element of the top-level list is a vector of indicies (rows of Y) that are pure samples of type i.}

\item{markers}{Marker gene indices. List of vectors. List should be same length as \code{pure_samples}, i.e. one element for each cell type. Each element of the top-level list is a vector of indicies (columns of Y) that will be considered markers of that particular type.}
}
\value{
List of vectors. Each vector is estimated estimated basline in pure samples of markers for each group, resp.
}
\description{
Estimate the offset terms.
}
\examples{
truth = shen_orr_ex$annotation$mixture
pure_samples <- lapply(1:3, function(i) {
   which(truth[, i] == 1)
})
Y <- shen_orr_ex$data$log
markers = find_markers(Y,pure_samples,data_type='microarray-gene',marker_method='ratio')$L
K = length(pure_samples)
n_choose = rep(20,K)
mrkrs <- lapply(1:K, function(i) {
       markers[[i]][1:n_choose[i]]
})
baseline_exprs(Y, pure_samples, mrkrs)
}
